/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.kubernetes.client.common.KubernetesObject;
import java.net.URI;
import java.util.function.Consumer;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.client.discovery.reactive.KubernetesInformerReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherConfigurationProperties;
import org.springframework.cloud.kubernetes.configuration.watcher.RefreshTrigger;
import org.springframework.core.log.LogAccessor;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

final class HttpRefreshTrigger
implements RefreshTrigger {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(HttpRefreshTrigger.class));
    private final KubernetesInformerReactiveDiscoveryClient kubernetesReactiveDiscoveryClient;
    private final ConfigurationWatcherConfigurationProperties k8SConfigurationProperties;
    private final WebClient webClient;

    HttpRefreshTrigger(KubernetesInformerReactiveDiscoveryClient kubernetesReactiveDiscoveryClient, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, WebClient webClient) {
        this.kubernetesReactiveDiscoveryClient = kubernetesReactiveDiscoveryClient;
        this.k8SConfigurationProperties = k8SConfigurationProperties;
        this.webClient = webClient;
    }

    public Mono<Void> triggerRefresh(KubernetesObject kubernetesObject, String appName) {
        return this.kubernetesReactiveDiscoveryClient.getInstances(appName).flatMap(si -> {
            URI actuatorUri = this.getActuatorUri(si, this.k8SConfigurationProperties.getActuatorPath(), this.k8SConfigurationProperties.getActuatorPort().intValue());
            LOG.debug(() -> "Sending refresh request for " + appName + " to URI " + actuatorUri);
            return ((WebClient.RequestBodySpec)this.webClient.post().uri(actuatorUri)).retrieve().toBodilessEntity().doOnSuccess(this.onSuccess(appName, actuatorUri)).doOnError(this.onError(appName));
        }).then();
    }

    private Consumer<ResponseEntity<Void>> onSuccess(String name, URI actuatorUri) {
        return re -> LOG.debug(() -> "Refresh sent to " + name + " at URI address " + actuatorUri + " returned a " + re.getStatusCode());
    }

    private Consumer<Throwable> onError(String name) {
        return t -> LOG.warn(t, () -> "Refresh sent to " + name + " failed");
    }

    private URI getActuatorUri(ServiceInstance si, String actuatorPath, int actuatorPort) {
        String metadataUri = si.getMetadata().getOrDefault("boot.spring.io/actuator", "");
        LOG.debug(() -> "Metadata actuator uri is: " + metadataUri);
        UriComponentsBuilder actuatorUriBuilder = UriComponentsBuilder.newInstance().scheme(si.getScheme()).host(si.getHost());
        if (StringUtils.hasText((String)metadataUri)) {
            LOG.debug(() -> "Found actuator URI in service instance metadata");
            this.setActuatorUriFromAnnotation(actuatorUriBuilder, metadataUri);
        } else {
            int port = actuatorPort < 0 ? si.getPort() : actuatorPort;
            actuatorUriBuilder = actuatorUriBuilder.path(actuatorPath + "/refresh").port(port);
        }
        return actuatorUriBuilder.build().toUri();
    }

    private void setActuatorUriFromAnnotation(UriComponentsBuilder actuatorUriBuilder, String metadataUri) {
        URI annotationUri = URI.create(metadataUri);
        actuatorUriBuilder.path(annotationUri.getPath() + "/refresh");
        if (annotationUri.getPort() < 0) {
            if (annotationUri.getAuthority() != null) {
                actuatorUriBuilder.port(annotationUri.getAuthority().replaceFirst(":", ""));
            }
        } else {
            actuatorUriBuilder.port(annotationUri.getPort());
        }
    }
}

