/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigMapWatcherChangeDetector;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherConfigurationProperties;
import org.springframework.cloud.kubernetes.configuration.watcher.HttpRefreshTrigger;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import reactor.core.publisher.Mono;

final class HttpBasedConfigMapWatchChangeDetector
extends ConfigMapWatcherChangeDetector {
    private final HttpRefreshTrigger httpRefreshTrigger;

    HttpBasedConfigMapWatchChangeDetector(CoreV1Api coreV1Api, ConfigurableEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientConfigMapPropertySourceLocator propertySourceLocator, KubernetesNamespaceProvider kubernetesNamespaceProvider, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, ThreadPoolTaskExecutor threadPoolTaskExecutor, HttpRefreshTrigger httpRefreshTrigger) {
        super(coreV1Api, environment, properties, strategy, propertySourceLocator, kubernetesNamespaceProvider, k8SConfigurationProperties, threadPoolTaskExecutor);
        this.httpRefreshTrigger = httpRefreshTrigger;
    }

    public Mono<Void> triggerRefresh(KubernetesObject configMap, String appName) {
        return this.httpRefreshTrigger.triggerRefresh(configMap, appName);
    }
}

