/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigMapWatcherChangeDetector;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherAutoConfiguration;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherConfigurationProperties;
import org.springframework.cloud.kubernetes.configuration.watcher.HttpBasedConfigMapWatchChangeDetector;
import org.springframework.cloud.kubernetes.configuration.watcher.HttpBasedSecretsWatchChangeDetector;
import org.springframework.cloud.kubernetes.configuration.watcher.HttpRefreshTrigger;
import org.springframework.cloud.kubernetes.configuration.watcher.SecretsWatcherChangeDetector;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ConfigurationWatcherConfigurationProperties.class})
@Import(value={RefreshTriggerConfiguration.class})
public class ConfigurationWatcherAutoConfiguration {
    private static final String AMQP = "bus-amqp";
    private static final String KAFKA = "bus-kafka";

    @Bean
    @ConditionalOnMissingBean
    public WebClient webClient(WebClient.Builder webClientBuilder) {
        return webClientBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean(value={ConfigMapWatcherChangeDetector.class})
    @ConditionalOnBean(value={KubernetesClientConfigMapPropertySourceLocator.class})
    public ConfigMapWatcherChangeDetector httpBasedConfigMapWatchChangeDetector(AbstractEnvironment environment, CoreV1Api coreV1Api, KubernetesClientConfigMapPropertySourceLocator configMapPropertySourceLocator, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, KubernetesNamespaceProvider namespaceProvider, ThreadPoolTaskExecutor threadFactory, HttpRefreshTrigger httpRefreshTrigger) {
        return new HttpBasedConfigMapWatchChangeDetector(coreV1Api, (ConfigurableEnvironment)environment, properties, strategy, configMapPropertySourceLocator, namespaceProvider, k8SConfigurationProperties, threadFactory, httpRefreshTrigger);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={KubernetesClientSecretsPropertySourceLocator.class})
    public SecretsWatcherChangeDetector httpBasedSecretsWatchChangeDetector(AbstractEnvironment environment, CoreV1Api coreV1Api, KubernetesClientSecretsPropertySourceLocator secretsPropertySourceLocator, KubernetesNamespaceProvider namespaceProvider, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, ThreadPoolTaskExecutor threadFactory, HttpRefreshTrigger httpRefreshTrigger) {
        return new HttpBasedSecretsWatchChangeDetector(coreV1Api, (ConfigurableEnvironment)environment, properties, strategy, secretsPropertySourceLocator, namespaceProvider, k8SConfigurationProperties, threadFactory, httpRefreshTrigger);
    }
}

