/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogAccessor;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
final class WatcherUtil {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(WatcherUtil.class));

    private WatcherUtil() {
    }

    static void onEvent(KubernetesObject kubernetesObject, String label, String annotationName, long refreshDelay, ScheduledExecutorService executorService, String type, BiFunction<KubernetesObject, String, Mono<Void>> triggerRefresh) {
        String name = kubernetesObject.getMetadata().getName();
        boolean isSpringCloudKubernetes = WatcherUtil.isSpringCloudKubernetes((KubernetesObject)kubernetesObject, (String)label);
        if (isSpringCloudKubernetes) {
            Set apps = WatcherUtil.apps((KubernetesObject)kubernetesObject, (String)annotationName);
            if (apps.isEmpty()) {
                apps.add(name);
            }
            LOG.info(() -> "will schedule remote refresh based on apps : " + apps);
            apps.forEach(appName -> WatcherUtil.schedule((String)type, (String)appName, (long)refreshDelay, (ScheduledExecutorService)executorService, (BiFunction)triggerRefresh, (KubernetesObject)kubernetesObject));
        } else {
            LOG.debug(() -> "Not publishing event." + type + ": " + name + " does not contain the label " + label);
        }
    }

    static boolean isSpringCloudKubernetes(KubernetesObject kubernetesObject, String label) {
        if (kubernetesObject.getMetadata() == null) {
            return false;
        }
        return Boolean.parseBoolean(WatcherUtil.labels((KubernetesObject)kubernetesObject).getOrDefault(label, "false"));
    }

    static Set<String> apps(KubernetesObject kubernetesObject, String annotationName) {
        HashSet<String> apps = new HashSet<String>(1);
        Map annotations = WatcherUtil.annotations((KubernetesObject)kubernetesObject);
        if (annotations.isEmpty()) {
            LOG.debug(() -> annotationName + " not present (empty data)");
            return apps;
        }
        String appsValue = (String)annotations.get(annotationName);
        if (appsValue == null) {
            LOG.debug(() -> annotationName + " not present (missing in annotations)");
            return apps;
        }
        if (appsValue.isBlank()) {
            LOG.debug(() -> appsValue + " not present (blanks only)");
            return apps;
        }
        return Arrays.stream(appsValue.split(",")).map(String::trim).collect(Collectors.toSet());
    }

    static Map<String, String> labels(KubernetesObject kubernetesObject) {
        V1ObjectMeta metadata = kubernetesObject.getMetadata();
        if (metadata == null) {
            return Map.of();
        }
        return Optional.ofNullable(metadata.getLabels()).orElse(Map.of());
    }

    static Map<String, String> annotations(KubernetesObject kubernetesObject) {
        V1ObjectMeta metadata = kubernetesObject.getMetadata();
        if (metadata == null) {
            return Map.of();
        }
        return Optional.ofNullable(metadata.getAnnotations()).orElse(Map.of());
    }

    private static void schedule(String type, String appName, long refreshDelay, ScheduledExecutorService executorService, BiFunction<KubernetesObject, String, Mono<Void>> triggerRefresh, KubernetesObject kubernetesObject) {
        LOG.debug(() -> "Scheduling remote refresh event to be published for " + type + ": with appName : " + appName + " to be published in " + refreshDelay + " milliseconds");
        executorService.schedule(() -> {
            try {
                ((Mono)triggerRefresh.apply(kubernetesObject, appName)).subscribe();
            }
            catch (Throwable t) {
                LOG.warn(t, (CharSequence)("Error when refreshing appName " + appName));
            }
        }, refreshDelay, TimeUnit.MILLISECONDS);
    }
}

