/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigMapWatcherChangeDetector;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherConfigurationProperties;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.discovery.reactive.KubernetesReactiveDiscoveryClient;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HttpBasedConfigMapWatchChangeDetector
extends ConfigMapWatcherChangeDetector {
    private Log log = LogFactory.getLog(this.getClass());
    public static String ANNOTATION_KEY = "boot.spring.io/actuator";
    private WebClient webClient;
    private KubernetesReactiveDiscoveryClient kubernetesReactiveDiscoveryClient;

    public HttpBasedConfigMapWatchChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy, Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, ThreadPoolTaskExecutor threadPoolTaskExecutor, WebClient webClient, KubernetesReactiveDiscoveryClient k8sReactiveDiscoveryClient) {
        super(environment, properties, kubernetesClient, strategy, fabric8ConfigMapPropertySourceLocator, k8SConfigurationProperties, threadPoolTaskExecutor);
        this.webClient = webClient;
        this.kubernetesReactiveDiscoveryClient = k8sReactiveDiscoveryClient;
    }

    private void setActuatorUriFromAnnotation(UriComponentsBuilder actuatorUriBuilder, String metadataUri) {
        URI annotationUri = URI.create(metadataUri);
        actuatorUriBuilder.path(annotationUri.getPath() + "/refresh");
        if (annotationUri.getPort() < 0) {
            if (annotationUri.getAuthority() != null) {
                actuatorUriBuilder.port(annotationUri.getAuthority().replaceFirst(":", ""));
            }
        } else {
            actuatorUriBuilder.port(annotationUri.getPort());
        }
    }

    private URI getActuatorUri(ServiceInstance si) {
        String metadataUri = si.getMetadata().getOrDefault(ANNOTATION_KEY, "");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Metadata actuator uri is: " + metadataUri));
        }
        UriComponentsBuilder actuatorUriBuilder = UriComponentsBuilder.newInstance().scheme(si.getScheme()).host(si.getHost());
        if (!StringUtils.isEmpty((Object)metadataUri)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Found actuator URI in service instance metadata");
            }
            this.setActuatorUriFromAnnotation(actuatorUriBuilder, metadataUri);
        } else {
            Integer port = this.k8SConfigurationProperties.getActuatorPort() < 0 ? si.getPort() : this.k8SConfigurationProperties.getActuatorPort().intValue();
            actuatorUriBuilder = actuatorUriBuilder.path(this.k8SConfigurationProperties.getActuatorPath() + "/refresh").port(port.intValue());
        }
        return actuatorUriBuilder.build().toUri();
    }

    protected Flux<ResponseEntity<Void>> refresh(ObjectMeta objectMeta) {
        return this.kubernetesReactiveDiscoveryClient.getInstances(objectMeta.getName()).flatMap(si -> {
            URI actuatorUri = this.getActuatorUri(si);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Sending refresh request for " + objectMeta.getName() + " to URI " + actuatorUri.toString()));
            }
            Mono response = ((WebClient.RequestBodySpec)this.webClient.post().uri(actuatorUri)).retrieve().toBodilessEntity().doOnSuccess(re -> {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Refresh sent to " + objectMeta.getName() + " at URI address " + actuatorUri + " returned a " + re.getStatusCode().toString()));
                }
            }).doOnError(t -> this.log.warn((Object)("Refresh sent to " + objectMeta.getName() + " failed"), t));
            return response;
        });
    }

    protected Mono<Void> triggerRefresh(ConfigMap configMap) {
        return this.refresh(configMap.getMetadata()).then();
    }
}

