/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config.reload;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.cloud.kubernetes.config.ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.config.SecretsPropertySource;
import org.springframework.cloud.kubernetes.config.SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class EventBasedConfigurationChangeDetector
extends ConfigurationChangeDetector {
    private ConfigMapPropertySourceLocator configMapPropertySourceLocator;
    private SecretsPropertySourceLocator secretsPropertySourceLocator;
    private Map<String, Watch> watches;

    public EventBasedConfigurationChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy, ConfigMapPropertySourceLocator configMapPropertySourceLocator, SecretsPropertySourceLocator secretsPropertySourceLocator) {
        super((ConfigurableEnvironment)environment, properties, kubernetesClient, strategy);
        this.configMapPropertySourceLocator = configMapPropertySourceLocator;
        this.secretsPropertySourceLocator = secretsPropertySourceLocator;
        this.watches = new HashMap<String, Watch>();
    }

    @PostConstruct
    public void watch() {
        String name;
        boolean activated = false;
        if (this.properties.isMonitoringConfigMaps() && this.configMapPropertySourceLocator != null) {
            try {
                name = "config-maps-watch";
                this.watches.put(name, (Watch)this.kubernetesClient.configMaps().watch((Object)new Watcher<ConfigMap>(){

                    public void eventReceived(Watcher.Action action, ConfigMap configMap) {
                        EventBasedConfigurationChangeDetector.this.onEvent(configMap);
                    }

                    public void onClose(KubernetesClientException e) {
                    }
                }));
                activated = true;
                this.log.info((Object)("Added new Kubernetes watch: " + name));
            }
            catch (Exception e) {
                this.log.error((Object)"Error while establishing a connection to watch config maps: configuration may remain stale", (Throwable)e);
            }
        }
        if (this.properties.isMonitoringSecrets() && this.secretsPropertySourceLocator != null) {
            try {
                activated = false;
                name = "secrets-watch";
                this.watches.put(name, (Watch)this.kubernetesClient.secrets().watch((Object)new Watcher<Secret>(){

                    public void eventReceived(Watcher.Action action, Secret secret) {
                        EventBasedConfigurationChangeDetector.this.onEvent(secret);
                    }

                    public void onClose(KubernetesClientException e) {
                    }
                }));
                activated = true;
                this.log.info((Object)("Added new Kubernetes watch: " + name));
            }
            catch (Exception e) {
                this.log.error((Object)"Error while establishing a connection to watch secrets: configuration may remain stale", (Throwable)e);
            }
        }
        if (activated) {
            this.log.info((Object)"Kubernetes event-based configuration change detector activated");
        }
    }

    @PreDestroy
    public void unwatch() {
        if (this.watches != null) {
            for (Map.Entry<String, Watch> entry : this.watches.entrySet()) {
                try {
                    this.log.debug((Object)("Closing the watch " + entry.getKey()));
                    entry.getValue().close();
                }
                catch (Exception e) {
                    this.log.error((Object)"Error while closing the watch connection", (Throwable)e);
                }
            }
        }
    }

    private void onEvent(ConfigMap configMap) {
        boolean changed = this.changed(this.locateMapPropertySources(this.configMapPropertySourceLocator, (Environment)this.environment), this.findPropertySources(ConfigMapPropertySource.class));
        if (changed) {
            this.log.info((Object)"Detected change in config maps");
            this.reloadProperties();
        }
    }

    private void onEvent(Secret secret) {
        boolean changed = this.changed(this.locateMapPropertySources(this.secretsPropertySourceLocator, (Environment)this.environment), this.findPropertySources(SecretsPropertySource.class));
        if (changed) {
            this.log.info((Object)"Detected change in secrets");
            this.reloadProperties();
        }
    }
}

