/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.discovery;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesServiceInstance;

@JsonIgnoreProperties(ignoreUnknown=true)
public record DefaultKubernetesServiceInstance(String instanceId, String serviceId, String host, int port, Map<String, String> metadata, boolean secure, String namespace, String cluster, Map<String, Map<String, String>> podMetadata) implements KubernetesServiceInstance,
Serializable
{
    public String getInstanceId() {
        return this.instanceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public URI getUri() {
        return this.createUri(this.secure ? "https" : "http", this.host, this.port);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getScheme() {
        return this.isSecure() ? "https" : "http";
    }

    @Override
    public String getNamespace() {
        return this.namespace != null ? this.namespace : this.metadata.get("k8s_namespace");
    }

    @Override
    public String getCluster() {
        return this.cluster;
    }

    private URI createUri(String scheme, String host, int port) {
        if (port == -1) {
            return URI.create(host);
        }
        if (port == 0) {
            return URI.create(scheme + "://" + host);
        }
        return URI.create(scheme + "://" + host + ":" + port);
    }
}

