/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.leader;

import java.util.HashMap;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.cloud.kubernetes.commons.leader.LeadershipController;
import org.springframework.integration.leader.Candidate;

public class LeaderInfoContributor
implements InfoContributor {
    private final LeadershipController leadershipController;
    private final Candidate candidate;

    public LeaderInfoContributor(LeadershipController leadershipController, Candidate candidate) {
        this.leadershipController = leadershipController;
        this.candidate = candidate;
    }

    public void contribute(Info.Builder builder) {
        HashMap details = new HashMap();
        this.leadershipController.getLocalLeader().ifPresentOrElse(leader -> {
            details.put("leaderId", leader.getId());
            details.put("role", leader.getRole());
            details.put("isLeader", leader.isCandidate(this.candidate));
        }, () -> details.put("leaderId", "Unknown"));
        builder.withDetail("leaderElection", details);
    }
}

