/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.PropertySourceUtils;
import org.springframework.cloud.kubernetes.commons.config.SourceData;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public class SourceDataEntriesProcessor
extends MapPropertySource {
    private static final Log LOG = LogFactory.getLog(SourceDataEntriesProcessor.class);
    private static final Predicate<String> ENDS_IN_EXTENSION = x -> x.endsWith(".yml") || x.endsWith(".yaml") || x.endsWith(".properties");

    public SourceDataEntriesProcessor(SourceData sourceData) {
        super(sourceData.sourceName(), sourceData.sourceData());
    }

    public static Map<String, Object> processAllEntries(Map<String, String> input, Environment environment) {
        return SourceDataEntriesProcessor.processAllEntries(input, environment, true);
    }

    public static Map<String, Object> processAllEntries(Map<String, String> input, Environment environment, boolean includeDefaultProfileData) {
        Set<Map.Entry<String, String>> entrySet = input.entrySet();
        if (entrySet.size() == 1) {
            Map.Entry<String, String> singleEntry = entrySet.iterator().next();
            String propertyName = singleEntry.getKey();
            String propertyValue = singleEntry.getValue();
            if (propertyName.endsWith(".yml") || propertyName.endsWith(".yaml")) {
                LOG.debug((Object)("The single property with name: [" + propertyName + "] will be treated as a yaml file"));
                return PropertySourceUtils.yamlParserGenerator(environment).andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(propertyValue);
            }
            if (propertyName.endsWith(".properties")) {
                LOG.debug((Object)("The single property with name: [" + propertyName + "] will be treated as a properties file"));
                return PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(propertyValue);
            }
        }
        return SourceDataEntriesProcessor.defaultProcessAllEntries(input, environment, includeDefaultProfileData);
    }

    static List<Map.Entry<String, String>> sorted(Map<String, String> input, Environment environment) {
        return SourceDataEntriesProcessor.sorted(input, environment, true);
    }

    static List<Map.Entry<String, String>> sorted(Map<String, String> rawData, Environment environment, boolean includeDefaultProfileData) {
        String applicationName = ConfigUtils.getApplicationName(environment, "", "");
        String[] activeProfiles = environment.getActiveProfiles();
        boolean includeDataEntry = includeDefaultProfileData || Arrays.asList(environment.getActiveProfiles()).contains("default");
        ArrayList<String> orderedFileNames = new ArrayList<String>();
        if (includeDataEntry) {
            orderedFileNames.add(applicationName);
        }
        orderedFileNames.addAll(Arrays.stream(activeProfiles).map(profile -> applicationName + "-" + profile).toList());
        int current = orderedFileNames.size() - 1;
        record WeightedEntry(Map.Entry<String, String> entry, int weight) {
        }
        ArrayList<WeightedEntry> weightedEntries = new ArrayList<WeightedEntry>();
        boolean plainEntriesOnly = rawData.keySet().stream().noneMatch(ENDS_IN_EXTENSION);
        if (plainEntriesOnly) {
            for (Map.Entry<String, String> entry : rawData.entrySet()) {
                weightedEntries.add(new WeightedEntry(entry, ++current));
            }
        } else {
            for (Map.Entry<String, String> entry : rawData.entrySet()) {
                String key = entry.getKey();
                if (ENDS_IN_EXTENSION.test(key)) {
                    String withoutExtension = key.split("\\.", 2)[0];
                    int index = orderedFileNames.indexOf(withoutExtension);
                    if (index >= 0) {
                        weightedEntries.add(new WeightedEntry(entry, index));
                        continue;
                    }
                    LOG.warn((Object)("entry : " + key + " will be skipped"));
                    continue;
                }
                if (!includeDataEntry) continue;
                weightedEntries.add(new WeightedEntry(entry, ++current));
            }
        }
        return weightedEntries.stream().sorted(Comparator.comparing(WeightedEntry::weight)).map(WeightedEntry::entry).toList();
    }

    private static Map<String, Object> defaultProcessAllEntries(Map<String, String> input, Environment environment, boolean includeDefaultProfile) {
        List<Map.Entry<String, String>> sortedEntries = SourceDataEntriesProcessor.sorted(input, environment, includeDefaultProfile);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : sortedEntries) {
            result.putAll(SourceDataEntriesProcessor.extractProperties(entry.getKey(), entry.getValue(), environment));
        }
        return result;
    }

    private static Map<String, Object> extractProperties(String resourceName, String content, Environment environment) {
        if (resourceName.endsWith(".yml") || resourceName.endsWith(".yaml") || resourceName.endsWith(".properties")) {
            if (resourceName.endsWith(".properties")) {
                LOG.debug((Object)("entry : " + resourceName + " will be treated as a single properties file"));
                return PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(content);
            }
            LOG.debug((Object)("entry : " + resourceName + " will be treated as a single yml/yaml file"));
            return PropertySourceUtils.yamlParserGenerator(environment).andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(content);
        }
        return Collections.singletonMap(resourceName, content);
    }
}

