/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config.reload;

import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshEndpointAutoConfiguration;
import org.springframework.cloud.commons.util.TaskSchedulerWrapper;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesConfigMapsOrSecretsEnabled;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.ConditionalOnKubernetesReloadEnabled;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@ConditionalOnKubernetesConfigMapsOrSecretsEnabled
@ConditionalOnKubernetesReloadEnabled
@ConditionalOnClass(value={EndpointAutoConfiguration.class, RestartEndpoint.class, ContextRefresher.class})
@AutoConfigureAfter(value={InfoEndpointAutoConfiguration.class, RefreshEndpointAutoConfiguration.class, RefreshAutoConfiguration.class})
public class ConfigReloadAutoConfiguration {
    @Bean(value={"springCloudKubernetesTaskScheduler"})
    @ConditionalOnMissingBean
    public TaskSchedulerWrapper<TaskScheduler> taskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setThreadNamePrefix("spring-cloud-kubernetes-ThreadPoolTaskScheduler-");
        threadPoolTaskScheduler.setDaemon(true);
        return new TaskSchedulerWrapper((TaskScheduler)threadPoolTaskScheduler);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigurationUpdateStrategy configurationUpdateStrategy(ConfigReloadProperties properties, ConfigurableApplicationContext ctx, Optional<RestartEndpoint> restarter, ContextRefresher refresher) {
        String strategyName = properties.strategy().name();
        return switch (properties.strategy()) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigReloadProperties.ReloadStrategy.RESTART_CONTEXT -> {
                restarter.orElseThrow(() -> new AssertionError((Object)"Restart endpoint is not enabled"));
                yield new ConfigurationUpdateStrategy(strategyName, () -> {
                    ConfigReloadAutoConfiguration.wait(properties);
                    ((RestartEndpoint)restarter.get()).restart();
                });
            }
            case ConfigReloadProperties.ReloadStrategy.REFRESH -> new ConfigurationUpdateStrategy(strategyName, () -> ((ContextRefresher)refresher).refresh());
            case ConfigReloadProperties.ReloadStrategy.SHUTDOWN -> new ConfigurationUpdateStrategy(strategyName, () -> {
                ConfigReloadAutoConfiguration.wait(properties);
                ctx.close();
            });
        };
    }

    private static void wait(ConfigReloadProperties properties) {
        long waitMillis = ThreadLocalRandom.current().nextLong(properties.maxWaitForRestart().toMillis());
        try {
            Thread.sleep(waitMillis);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }
}

