/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.PrefixContext;
import org.springframework.cloud.kubernetes.commons.config.SourceData;

public abstract class LabeledSourceData {
    public final SourceData compute(Map<String, String> labels, ConfigUtils.Prefix prefix, String target, boolean profileSources, boolean failFast, String namespace, String[] activeProfiles) {
        MultipleSourcesContainer data = MultipleSourcesContainer.empty();
        try {
            Set<String> profiles = Set.of();
            if (profileSources) {
                profiles = Arrays.stream(activeProfiles).collect(Collectors.toSet());
            }
            if ((data = this.dataSupplier(labels, profiles)).names().isEmpty()) {
                String names = labels.keySet().stream().sorted().collect(Collectors.joining("."));
                return SourceData.emptyRecord(ConfigUtils.sourceName(target, names, namespace));
            }
            if (prefix != ConfigUtils.Prefix.DEFAULT) {
                String prefixToUse = prefix == ConfigUtils.Prefix.KNOWN ? prefix.prefixProvider().get() : data.names().stream().sorted().collect(Collectors.joining("."));
                PrefixContext prefixContext = new PrefixContext(data.data(), prefixToUse, namespace, data.names());
                return ConfigUtils.withPrefix(target, prefixContext);
            }
        }
        catch (Exception e) {
            ConfigUtils.onException(failFast, e);
        }
        String names = data.names().stream().sorted().collect(Collectors.joining("."));
        return new SourceData(ConfigUtils.sourceName(target, names, namespace), data.data());
    }

    public abstract MultipleSourcesContainer dataSupplier(Map<String, String> var1, Set<String> var2);
}

