/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public abstract class SecretsPropertySourceLocator
implements PropertySourceLocator {
    private static final Log LOG = LogFactory.getLog(SecretsPropertySourceLocator.class);
    protected final SecretsConfigProperties properties;

    public SecretsPropertySourceLocator(SecretsConfigProperties properties) {
        this.properties = properties;
    }

    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            List<SecretsConfigProperties.NormalizedSource> sources = this.properties.determineSources();
            HashSet<SecretsConfigProperties.NormalizedSource> uniqueSources = new HashSet<SecretsConfigProperties.NormalizedSource>(sources);
            LOG.debug((Object)("Secrets normalized sources : " + sources));
            CompositePropertySource composite = new CompositePropertySource("composite-secrets");
            this.putPathConfig(composite);
            if (this.properties.isEnableApi()) {
                uniqueSources.forEach(s -> composite.addPropertySource((PropertySource)this.getMapPropertySourceForSingleSecret(env, (SecretsConfigProperties.NormalizedSource)s)));
            }
            return composite;
        }
        return null;
    }

    private MapPropertySource getMapPropertySourceForSingleSecret(ConfigurableEnvironment environment, SecretsConfigProperties.NormalizedSource normalizedSource) {
        String configurationTarget = this.properties.getConfigurationTarget();
        return this.getPropertySource(environment, normalizedSource, configurationTarget);
    }

    protected abstract MapPropertySource getPropertySource(ConfigurableEnvironment var1, SecretsConfigProperties.NormalizedSource var2, String var3);

    protected void putPathConfig(CompositePropertySource composite) {
        this.properties.getPaths().stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(x -> {
            try {
                return Files.walk(x, new FileVisitOption[0]);
            }
            catch (IOException e) {
                LOG.warn((Object)"Error walking properties files", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(new MapPropertySourceCollector()).forEach(arg_0 -> ((CompositePropertySource)composite).addPropertySource(arg_0));
    }

    private static class MapPropertySourceCollector
    implements Collector<Path, List<MapPropertySource>, List<MapPropertySource>> {
        private MapPropertySourceCollector() {
        }

        @Override
        public Supplier<List<MapPropertySource>> supplier() {
            return ArrayList::new;
        }

        @Override
        public BiConsumer<List<MapPropertySource>, Path> accumulator() {
            return (list, filePath) -> {
                MapPropertySource source = this.property((Path)filePath);
                if (source != null) {
                    list.add(source);
                }
            };
        }

        @Override
        public BinaryOperator<List<MapPropertySource>> combiner() {
            return (left, right) -> {
                left.addAll(right);
                return left;
            };
        }

        @Override
        public Function<List<MapPropertySource>, List<MapPropertySource>> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
        }

        private MapPropertySource property(Path filePath) {
            String fileName = filePath.getFileName().toString();
            try {
                String content = new String(Files.readAllBytes(filePath)).trim();
                return new MapPropertySource(fileName.toLowerCase(), Collections.singletonMap(fileName, content));
            }
            catch (IOException e) {
                LOG.warn((Object)"Error reading properties file", (Throwable)e);
                return null;
            }
        }
    }
}

