/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.profile;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public abstract class AbstractKubernetesProfileEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Log LOG = LogFactory.getLog(AbstractKubernetesProfileEnvironmentPostProcessor.class);
    private static final String NAMESPACE_PATH_PROPERTY = "spring.cloud.kubernetes.client.serviceAccountNamespacePath";
    protected static final String NAMESPACE_PROPERTY = "spring.cloud.kubernetes.client.namespace";
    private static final String PROPERTY_SOURCE_NAME = "KUBERNETES_NAMESPACE_PROPERTY_SOURCE";
    private static final int ORDER = -2147483639;
    public static final String KUBERNETES_PROFILE = "kubernetes";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        boolean kubernetesEnabled = (Boolean)environment.getProperty("spring.cloud.kubernetes.enabled", Boolean.class, (Object)true);
        if (!kubernetesEnabled) {
            return;
        }
        this.addNamespaceFromServiceAccountFile(environment);
        if (this.isInsideKubernetes((Environment)environment)) {
            if (this.hasKubernetesProfile((Environment)environment)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"'kubernetes' already in list of active profiles");
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Adding 'kubernetes' to list of active profiles");
                }
                environment.addActiveProfile(KUBERNETES_PROFILE);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.warn((Object)"Not running inside kubernetes. Skipping 'kubernetes' profile activation.");
        }
    }

    protected abstract boolean isInsideKubernetes(Environment var1);

    private boolean hasKubernetesProfile(Environment environment) {
        for (String activeProfile : environment.getActiveProfiles()) {
            if (!KUBERNETES_PROFILE.equalsIgnoreCase(activeProfile)) continue;
            return true;
        }
        return false;
    }

    public int getOrder() {
        return -2147483639;
    }

    private void addNamespaceFromServiceAccountFile(ConfigurableEnvironment environment) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String serviceAccountNamespace = environment.getProperty(NAMESPACE_PATH_PROPERTY, "/var/run/secrets/kubernetes.io/serviceaccount/namespace");
        LOG.debug((Object)("Looking for service account namespace at " + serviceAccountNamespace));
        boolean serviceAccountNamespaceExists = Files.isRegularFile(new File(serviceAccountNamespace).toPath(), new LinkOption[0]);
        if (serviceAccountNamespaceExists) {
            LOG.debug((Object)("Found service account namespace at: [" + serviceAccountNamespace + "]."));
            try {
                String namespace = new String(Files.readAllBytes(new File(serviceAccountNamespace).toPath()));
                LOG.debug((Object)("Service account namespace value: " + namespace));
                properties.put(NAMESPACE_PROPERTY, namespace);
            }
            catch (IOException var4) {
                LOG.error((Object)("Error reading service account namespace from: [" + serviceAccountNamespace + "]."), (Throwable)var4);
            }
        } else {
            LOG.info((Object)("Did not find service account namespace at: [" + serviceAccountNamespace + "]. Ignoring."));
        }
        environment.getPropertySources().addLast((PropertySource)new MapPropertySource(PROPERTY_SOURCE_NAME, properties));
    }
}

