/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.loadbalancer;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Service;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesServiceInstanceMapper;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesServicesListSupplier;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;
import reactor.core.publisher.Flux;

public class KubernetesClientServicesListSupplier
extends KubernetesServicesListSupplier<V1Service> {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientServicesListSupplier.class));
    private final CoreV1Api coreV1Api;
    private final KubernetesNamespaceProvider kubernetesNamespaceProvider;

    public KubernetesClientServicesListSupplier(Environment environment, KubernetesServiceInstanceMapper<V1Service> mapper, KubernetesDiscoveryProperties discoveryProperties, CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        super(environment, mapper, discoveryProperties);
        this.coreV1Api = coreV1Api;
        this.kubernetesNamespaceProvider = kubernetesNamespaceProvider;
    }

    public Flux<List<ServiceInstance>> get() {
        return Flux.defer(() -> {
            ArrayList result = new ArrayList();
            String serviceName = this.getServiceId();
            LOG.debug(() -> "serviceID : " + serviceName);
            if (this.discoveryProperties.allNamespaces()) {
                LOG.debug(() -> "discovering services in all namespaces");
                List<V1Service> services = this.services(null, serviceName);
                services.forEach(service -> this.addMappedService((KubernetesServiceInstanceMapper<V1Service>)this.mapper, result, (V1Service)service));
            } else if (!this.discoveryProperties.namespaces().isEmpty()) {
                List selectiveNamespaces = this.discoveryProperties.namespaces().stream().sorted().toList();
                LOG.debug(() -> "discovering services in selective namespaces : " + selectiveNamespaces);
                selectiveNamespaces.forEach(selectiveNamespace -> {
                    List<V1Service> services = this.services((String)selectiveNamespace, serviceName);
                    services.forEach(service -> this.addMappedService((KubernetesServiceInstanceMapper<V1Service>)this.mapper, result, (V1Service)service));
                });
            } else {
                String namespace = KubernetesClientUtils.getApplicationNamespace(null, (String)"loadbalancer-service", (KubernetesNamespaceProvider)this.kubernetesNamespaceProvider);
                LOG.debug(() -> "discovering services in namespace : " + namespace);
                List<V1Service> services = this.services(namespace, serviceName);
                services.forEach(service -> this.addMappedService((KubernetesServiceInstanceMapper<V1Service>)this.mapper, result, (V1Service)service));
            }
            LOG.debug(() -> "found services : " + result);
            return Flux.just(result);
        });
    }

    private void addMappedService(KubernetesServiceInstanceMapper<V1Service> mapper, List<ServiceInstance> services, V1Service service) {
        services.add((ServiceInstance)mapper.map((Object)service));
    }

    private List<V1Service> services(String namespace, String serviceName) {
        if (namespace == null) {
            try {
                return this.coreV1Api.listServiceForAllNamespaces(null, null, "metadata.name=" + serviceName, null, null, null, null, null, null, null, null).getItems();
            }
            catch (ApiException apiException) {
                LOG.warn((Throwable)apiException, (CharSequence)("Error retrieving services (in all namespaces) with name " + serviceName));
                return List.of();
            }
        }
        try {
            return this.coreV1Api.listNamespacedService(namespace, null, null, null, "metadata.name=" + serviceName, null, null, null, null, null, null, null).getItems();
        }
        catch (ApiException apiException) {
            LOG.warn((Throwable)apiException, (CharSequence)("Error retrieving service with name " + serviceName + " in namespace : " + namespace));
            return List.of();
        }
    }
}

