/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.loadbalancer;

import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServicePort;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesLoadBalancerProperties;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesServiceInstanceMapper;
import org.springframework.util.StringUtils;

public class KubernetesClientServiceInstanceMapper
implements KubernetesServiceInstanceMapper<V1Service> {
    private KubernetesLoadBalancerProperties properties;
    private KubernetesDiscoveryProperties discoveryProperties;

    public KubernetesClientServiceInstanceMapper(KubernetesLoadBalancerProperties properties, KubernetesDiscoveryProperties discoveryProperties) {
        this.properties = properties;
        this.discoveryProperties = discoveryProperties;
    }

    public KubernetesServiceInstance map(V1Service service) {
        Optional<V1ServicePort> optPort;
        V1ObjectMeta meta = service.getMetadata();
        List ports = service.getSpec().getPorts();
        V1ServicePort port = null;
        if (ports.size() == 1) {
            port = (V1ServicePort)ports.get(0);
        } else if (ports.size() > 1 && StringUtils.hasText((String)this.properties.getPortName()) && (optPort = ports.stream().filter(it -> this.properties.getPortName().endsWith(it.getName())).findAny()).isPresent()) {
            port = optPort.get();
        }
        if (port == null) {
            return null;
        }
        String host = KubernetesServiceInstanceMapper.createHost((String)service.getMetadata().getName(), (String)service.getMetadata().getNamespace(), (String)this.properties.getClusterDomain());
        boolean secure = KubernetesServiceInstanceMapper.isSecure((Map)service.getMetadata().getLabels(), (Map)service.getMetadata().getAnnotations(), (String)port.getName(), (Integer)port.getPort());
        return new KubernetesServiceInstance(meta.getUid(), meta.getName(), host, port.getPort().intValue(), this.getServiceMetadata(service), Boolean.valueOf(secure));
    }

    private Map<String, String> getServiceMetadata(V1Service service) {
        HashMap<String, String> serviceMetadata = new HashMap<String, String>();
        KubernetesDiscoveryProperties.Metadata metadataProps = this.discoveryProperties.getMetadata();
        if (metadataProps.isAddLabels()) {
            Map labelMetadata = KubernetesServiceInstanceMapper.getMapWithPrefixedKeys((Map)service.getMetadata().getLabels(), (String)metadataProps.getLabelsPrefix());
            serviceMetadata.putAll(labelMetadata);
        }
        if (metadataProps.isAddAnnotations()) {
            Map annotationMetadata = KubernetesServiceInstanceMapper.getMapWithPrefixedKeys((Map)service.getMetadata().getAnnotations(), (String)metadataProps.getAnnotationsPrefix());
            serviceMetadata.putAll(annotationMetadata);
        }
        return serviceMetadata;
    }
}

