/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.leader.election;

import io.kubernetes.client.openapi.ApiClient;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.client.KubernetesClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.leader.election.KubernetesClientLeaderElectionCallbacks;
import org.springframework.cloud.kubernetes.commons.leader.election.ConditionalOnLeaderElectionEnabled;
import org.springframework.cloud.kubernetes.commons.leader.election.LeaderElectionCallbacks;
import org.springframework.cloud.kubernetes.commons.leader.election.LeaderElectionProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LeaderElectionProperties.class})
@ConditionalOnBean(value={ApiClient.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@ConditionalOnLeaderElectionEnabled
@AutoConfigureAfter(value={KubernetesClientAutoConfiguration.class})
public class KubernetesClientLeaderElectionCallbacksAutoConfiguration
extends LeaderElectionCallbacks {
    @Bean
    @ConditionalOnMissingBean
    KubernetesClientLeaderElectionCallbacks kubernetesClientLeaderElectionCallbacks(Runnable onStartLeadingCallback, Runnable onStopLeadingCallback, Consumer<String> onNewLeaderCallback) {
        return new KubernetesClientLeaderElectionCallbacks(onStartLeadingCallback, onStopLeadingCallback, onNewLeaderCallback);
    }
}

