/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.leader.election;

import io.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.kubernetes.client.extended.leaderelection.Lock;
import io.kubernetes.client.extended.leaderelection.resourcelock.ConfigMapLock;
import io.kubernetes.client.extended.leaderelection.resourcelock.LeaseLock;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.CustomObjectsApi;
import io.kubernetes.client.openapi.models.V1APIResource;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodCondition;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.client.leader.election.KubernetesClientLeaderElectionCallbacks;
import org.springframework.cloud.kubernetes.client.leader.election.KubernetesClientLeaderElectionCallbacksAutoConfiguration;
import org.springframework.cloud.kubernetes.client.leader.election.KubernetesClientLeaderElectionInfoContributor;
import org.springframework.cloud.kubernetes.client.leader.election.KubernetesClientLeaderElectionInitiator;
import org.springframework.cloud.kubernetes.commons.leader.election.ConditionalOnLeaderElectionEnabled;
import org.springframework.cloud.kubernetes.commons.leader.election.LeaderElectionProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.log.LogAccessor;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LeaderElectionProperties.class})
@ConditionalOnBean(value={ApiClient.class})
@ConditionalOnLeaderElectionEnabled
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@AutoConfigureAfter(value={KubernetesClientLeaderElectionCallbacksAutoConfiguration.class})
class KubernetesClientLeaderElectionAutoConfiguration {
    private static final LogAccessor LOG = new LogAccessor(KubernetesClientLeaderElectionAutoConfiguration.class);

    KubernetesClientLeaderElectionAutoConfiguration() {
    }

    @Bean
    @ConditionalOnClass(value={InfoContributor.class})
    @ConditionalOnEnabledInfoContributor(value="leader.election")
    KubernetesClientLeaderElectionInfoContributor kubernetesClientLeaderElectionInfoContributor(String candidateIdentity, LeaderElectionConfig leaderElectionConfig) {
        return new KubernetesClientLeaderElectionInfoContributor(candidateIdentity, leaderElectionConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    KubernetesClientLeaderElectionInitiator kubernetesClientLeaderElectionInitiator(String candidateIdentity, String podNamespace, LeaderElectionConfig leaderElectionConfig, LeaderElectionProperties leaderElectionProperties, BooleanSupplier podReadySupplier, KubernetesClientLeaderElectionCallbacks callbacks) {
        return new KubernetesClientLeaderElectionInitiator(candidateIdentity, podNamespace, leaderElectionConfig, leaderElectionProperties, podReadySupplier, callbacks);
    }

    @Bean
    @ConditionalOnMissingBean
    BooleanSupplier kubernetesClientPodReadySupplier(CoreV1Api coreV1Api, String candidateIdentity, String podNamespace) {
        return () -> {
            try {
                V1Pod pod = coreV1Api.readNamespacedPod(candidateIdentity, podNamespace).execute();
                return KubernetesClientLeaderElectionAutoConfiguration.isPodReady(pod);
            }
            catch (ApiException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    LeaderElectionConfig kubernetesClientLeaderElectionConfig(LeaderElectionProperties properties, Lock lock) {
        return new LeaderElectionConfig(lock, properties.leaseDuration(), properties.renewDeadline(), properties.retryPeriod());
    }

    @Bean
    @ConditionalOnMissingBean
    Lock kubernetesClientLeaderElectionLock(ApiClient apiClient, LeaderElectionProperties properties, String candidateIdentity) {
        boolean leaseSupported;
        CustomObjectsApi customObjectsApi = new CustomObjectsApi(apiClient);
        try {
            List resources = customObjectsApi.getAPIResources("coordination.k8s.io", "v1").execute().getResources();
            leaseSupported = resources.stream().map(V1APIResource::getKind).anyMatch("Lease"::equals);
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
        if (leaseSupported) {
            if (properties.useConfigMapAsLock()) {
                LOG.info(() -> "leases are supported on the cluster, but config map will be used (because 'spring.cloud.kubernetes.leader.election.use-config-map-as-lock=true')");
                return new ConfigMapLock(properties.lockNamespace(), properties.lockName(), candidateIdentity);
            }
            LOG.info(() -> "will use lease as the lock for leader election");
            return new LeaseLock(properties.lockNamespace(), properties.lockName(), candidateIdentity, apiClient);
        }
        LOG.info(() -> "will use configmap as the lock for leader election");
        return new ConfigMapLock(properties.lockNamespace(), properties.lockName(), candidateIdentity, apiClient);
    }

    private static boolean isPodReady(V1Pod pod) {
        Objects.requireNonNull(pod, "Pod can't be null.");
        V1PodCondition condition = KubernetesClientLeaderElectionAutoConfiguration.getPodReadyCondition(pod);
        if (condition == null) {
            return false;
        }
        return condition.getStatus().equalsIgnoreCase("True");
    }

    private static V1PodCondition getPodReadyCondition(V1Pod pod) {
        if (pod.getStatus() == null || pod.getStatus().getConditions() == null) {
            return null;
        }
        for (V1PodCondition condition : pod.getStatus().getConditions()) {
            if (!"Ready".equals(condition.getType())) continue;
            return condition;
        }
        return null;
    }
}

