/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Service;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.ReactiveCommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.composite.reactive.ReactiveCompositeDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientDiscoveryClientSpelAutoConfiguration;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientInformerDiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientInformerReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientInformerReactiveDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryClientHealthIndicatorInitializer;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryPropertiesAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnSpringCloudKubernetesReactiveDiscovery;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnSpringCloudKubernetesReactiveDiscoveryHealthInitializer;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.log.LogAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSpringCloudKubernetesReactiveDiscovery
@AutoConfigureBefore(value={SimpleReactiveDiscoveryClientAutoConfiguration.class, ReactiveCommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={ReactiveCompositeDiscoveryClientAutoConfiguration.class, KubernetesDiscoveryPropertiesAutoConfiguration.class, KubernetesClientDiscoveryClientSpelAutoConfiguration.class, KubernetesClientInformerReactiveDiscoveryClientAutoConfiguration.class})
class KubernetesClientInformerReactiveHealthAutoConfiguration {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientInformerReactiveHealthAutoConfiguration.class));

    KubernetesClientInformerReactiveHealthAutoConfiguration() {
    }

    @Bean
    @ConditionalOnBean(value={KubernetesClientInformerReactiveDiscoveryClient.class})
    @ConditionalOnSpringCloudKubernetesReactiveDiscoveryHealthInitializer
    ReactiveDiscoveryClientHealthIndicator nonCacheableReactiveDiscoveryClientHealthIndicator(KubernetesClientInformerReactiveDiscoveryClient reactiveClient, DiscoveryClientHealthIndicatorProperties properties) {
        return new ReactiveDiscoveryClientHealthIndicator((ReactiveDiscoveryClient)reactiveClient, properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={KubernetesClientInformerReactiveDiscoveryClient.class})
    @ConditionalOnSpringCloudKubernetesReactiveDiscoveryHealthInitializer
    ReactiveDiscoveryClientHealthIndicator cacheableReactiveDiscoveryClientHealthIndicator(List<SharedInformerFactory> sharedInformerFactories, List<Lister<V1Service>> serviceListers, List<Lister<V1Endpoints>> endpointsListers, List<SharedInformer<V1Service>> serviceInformers, List<SharedInformer<V1Endpoints>> endpointsInformers, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, CoreV1Api coreV1Api, Predicate<V1Service> predicate, DiscoveryClientHealthIndicatorProperties properties) {
        KubernetesClientInformerDiscoveryClient blockingClient = new KubernetesClientInformerDiscoveryClient(sharedInformerFactories, serviceListers, endpointsListers, serviceInformers, endpointsInformers, kubernetesDiscoveryProperties, coreV1Api, predicate);
        blockingClient.afterPropertiesSet();
        KubernetesClientInformerReactiveDiscoveryClient reactiveClient = new KubernetesClientInformerReactiveDiscoveryClient(blockingClient);
        return new ReactiveDiscoveryClientHealthIndicator((ReactiveDiscoveryClient)reactiveClient, properties);
    }

    @Bean
    @ConditionalOnSpringCloudKubernetesReactiveDiscoveryHealthInitializer
    KubernetesDiscoveryClientHealthIndicatorInitializer reactiveIndicatorInitializer(ApplicationEventPublisher applicationEventPublisher, PodUtils<?> podUtils) {
        LOG.debug(() -> "Will publish InstanceRegisteredEvent from reactive implementation");
        return new KubernetesDiscoveryClientHealthIndicatorInitializer(podUtils, applicationEventPublisher);
    }
}

