/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.kubernetes.client.KubernetesClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientCatalogWatch;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryPropertiesAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnKubernetesCatalogWatcherEnabled;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesCatalogWatcherEnabled
@AutoConfigureAfter(value={KubernetesClientAutoConfiguration.class, KubernetesDiscoveryPropertiesAutoConfiguration.class})
final class KubernetesClientCatalogWatchAutoConfiguration {
    KubernetesClientCatalogWatchAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    KubernetesClientCatalogWatch kubernetesClientCatalogWatch(CoreV1Api coreV1Api, ApiClient apiClient, KubernetesDiscoveryProperties properties, Environment environment, ApplicationEventPublisher publisher) {
        return new KubernetesClientCatalogWatch(coreV1Api, apiClient, properties, new KubernetesNamespaceProvider(environment), publisher);
    }
}

