/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery.catalog;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;

record KubernetesCatalogWatchContext(CoreV1Api coreV1Api, ApiClient apiClient, KubernetesDiscoveryProperties properties, KubernetesNamespaceProvider namespaceProvider) {
    static List<EndpointNameAndNamespace> state(Stream<V1ObjectReference> references) {
        return references.filter(Objects::nonNull).map(x -> new EndpointNameAndNamespace(x.getName(), x.getNamespace())).sorted(Comparator.comparing(EndpointNameAndNamespace::endpointName, String::compareTo)).toList();
    }

    static String labelSelector(Map<String, String> labels) {
        return labels.entrySet().stream().map(en -> (String)en.getKey() + "=" + (String)en.getValue()).collect(Collectors.joining(","));
    }
}

