/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Service;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.K8sInstanceIdHostPodNameSupplier;
import org.springframework.cloud.kubernetes.client.discovery.K8sPodLabelsAndAnnotationsSupplier;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesDiscoveryClientUtils;
import org.springframework.cloud.kubernetes.commons.discovery.DiscoveryClientUtils;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.ServiceMetadata;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortNameAndNumber;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortSecureResolver;
import org.springframework.core.log.LogAccessor;

public class KubernetesInformerDiscoveryClient
implements DiscoveryClient {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesInformerDiscoveryClient.class));
    private final List<SharedInformerFactory> sharedInformerFactories;
    private final List<Lister<V1Service>> serviceListers;
    private final List<Lister<V1Endpoints>> endpointsListers;
    private final Supplier<Boolean> informersReadyFunc;
    private final KubernetesDiscoveryProperties properties;
    private final Predicate<V1Service> filter;
    private final ServicePortSecureResolver servicePortSecureResolver;
    @Autowired
    CoreV1Api coreV1Api;

    @Deprecated(forRemoval=true)
    public KubernetesInformerDiscoveryClient(String namespace, SharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
        this.sharedInformerFactories = List.of(sharedInformerFactory);
        this.serviceListers = List.of(serviceLister);
        this.endpointsListers = List.of(endpointsLister);
        this.informersReadyFunc = () -> serviceInformer.hasSynced() && endpointsInformer.hasSynced();
        this.properties = properties;
        this.filter = KubernetesDiscoveryClientUtils.filter(properties);
        this.servicePortSecureResolver = new ServicePortSecureResolver(properties);
    }

    public KubernetesInformerDiscoveryClient(SharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
        this.sharedInformerFactories = List.of(sharedInformerFactory);
        this.serviceListers = List.of(serviceLister);
        this.endpointsListers = List.of(endpointsLister);
        this.informersReadyFunc = () -> serviceInformer.hasSynced() && endpointsInformer.hasSynced();
        this.properties = properties;
        this.filter = KubernetesDiscoveryClientUtils.filter(properties);
        this.servicePortSecureResolver = new ServicePortSecureResolver(properties);
    }

    public KubernetesInformerDiscoveryClient(List<SharedInformerFactory> sharedInformerFactories, List<Lister<V1Service>> serviceListers, List<Lister<V1Endpoints>> endpointsListers, List<SharedInformer<V1Service>> serviceInformers, List<SharedInformer<V1Endpoints>> endpointsInformers, KubernetesDiscoveryProperties properties) {
        this.sharedInformerFactories = sharedInformerFactories;
        this.serviceListers = serviceListers;
        this.endpointsListers = endpointsListers;
        this.informersReadyFunc = () -> {
            boolean serviceInformersReady = serviceInformers.isEmpty() || serviceInformers.stream().map(SharedInformer::hasSynced).reduce(Boolean::logicalAnd).orElse(false) != false;
            boolean endpointsInformersReady = endpointsInformers.isEmpty() || endpointsInformers.stream().map(SharedInformer::hasSynced).reduce(Boolean::logicalAnd).orElse(false) != false;
            return serviceInformersReady && endpointsInformersReady;
        };
        this.properties = properties;
        this.filter = KubernetesDiscoveryClientUtils.filter(properties);
        this.servicePortSecureResolver = new ServicePortSecureResolver(properties);
    }

    public String description() {
        return "Kubernetes Client Discovery";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        Objects.requireNonNull(serviceId, "serviceId must be provided");
        List<V1Service> allServices = this.serviceListers.stream().flatMap(x -> x.list().stream()).filter(scv -> scv.getMetadata() != null).filter(svc -> serviceId.equals(svc.getMetadata().getName())).filter(scv -> KubernetesDiscoveryClientUtils.matchesServiceLabels(scv, this.properties)).toList();
        List serviceInstances = allServices.stream().filter(this.filter).flatMap(service -> this.serviceInstances((V1Service)service, serviceId).stream()).collect(Collectors.toCollection(ArrayList::new));
        if (this.properties.includeExternalNameServices()) {
            LOG.debug(() -> "Searching for 'ExternalName' type of services with serviceId : " + serviceId);
            List<V1Service> externalNameServices = allServices.stream().filter(s -> s.getSpec() != null).filter(s -> "ExternalName".equals(s.getSpec().getType())).toList();
            for (V1Service service2 : externalNameServices) {
                ServiceMetadata serviceMetadata = KubernetesDiscoveryClientUtils.serviceMetadata(service2);
                Map serviceInstanceMetadata = DiscoveryClientUtils.serviceInstanceMetadata(Map.of(), (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.properties);
                K8sInstanceIdHostPodNameSupplier supplierOne = K8sInstanceIdHostPodNameSupplier.externalName(service2);
                K8sPodLabelsAndAnnotationsSupplier supplierTwo = K8sPodLabelsAndAnnotationsSupplier.externalName();
                ServiceInstance externalNameServiceInstance = DiscoveryClientUtils.serviceInstance(null, (ServiceMetadata)serviceMetadata, (Supplier)supplierOne, (Function)supplierTwo, (ServicePortNameAndNumber)new ServicePortNameAndNumber(-1, null), (Map)serviceInstanceMetadata, (KubernetesDiscoveryProperties)this.properties);
                serviceInstances.add(externalNameServiceInstance);
            }
        }
        return serviceInstances;
    }

    private List<ServiceInstance> serviceInstances(V1Service service, String serviceId) {
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        List<V1Endpoints> allEndpoints = this.endpointsListers.stream().map(endpointsLister -> (V1Endpoints)endpointsLister.namespace(service.getMetadata().getNamespace()).get(serviceId)).filter(Objects::nonNull).toList();
        for (V1Endpoints endpoints : allEndpoints) {
            List subsets = endpoints.getSubsets();
            if (subsets == null || subsets.isEmpty()) {
                LOG.debug(() -> "serviceId : " + serviceId + " does not have any subsets");
                continue;
            }
            ServiceMetadata serviceMetadata = KubernetesDiscoveryClientUtils.serviceMetadata(service);
            Map<String, Integer> portsData = KubernetesDiscoveryClientUtils.endpointSubsetsPortData(subsets);
            Map serviceInstanceMetadata = DiscoveryClientUtils.serviceInstanceMetadata(portsData, (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.properties);
            for (V1EndpointSubset endpointSubset : subsets) {
                Map<String, Integer> endpointsPortData = KubernetesDiscoveryClientUtils.endpointSubsetsPortData(List.of(endpointSubset));
                ServicePortNameAndNumber portData = DiscoveryClientUtils.endpointsPort(endpointsPortData, (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.properties);
                List<V1EndpointAddress> addresses = KubernetesDiscoveryClientUtils.addresses(endpointSubset, this.properties);
                for (V1EndpointAddress endpointAddress : addresses) {
                    K8sInstanceIdHostPodNameSupplier supplierOne = K8sInstanceIdHostPodNameSupplier.nonExternalName(endpointAddress, service);
                    K8sPodLabelsAndAnnotationsSupplier supplierTwo = K8sPodLabelsAndAnnotationsSupplier.nonExternalName(this.coreV1Api, service.getMetadata().getNamespace());
                    ServiceInstance serviceInstance = DiscoveryClientUtils.serviceInstance((ServicePortSecureResolver)this.servicePortSecureResolver, (ServiceMetadata)serviceMetadata, (Supplier)supplierOne, (Function)supplierTwo, (ServicePortNameAndNumber)portData, (Map)serviceInstanceMetadata, (KubernetesDiscoveryProperties)this.properties);
                    instances.add(serviceInstance);
                }
            }
        }
        return instances;
    }

    public List<String> getServices() {
        List<String> services = this.serviceListers.stream().flatMap(serviceLister -> serviceLister.list().stream()).filter(service -> KubernetesDiscoveryClientUtils.matchesServiceLabels(service, this.properties)).filter(this.filter).map(s -> s.getMetadata().getName()).distinct().toList();
        LOG.debug(() -> "will return services : " + services);
        return services;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        KubernetesDiscoveryClientUtils.postConstruct(this.sharedInformerFactories, this.properties, this.informersReadyFunc, this.serviceListers);
    }

    public int getOrder() {
        return this.properties.order();
    }
}

