/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery.reactive;

import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Service;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryHealthIndicatorEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ReactiveCommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.composite.reactive.ReactiveCompositeDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.KubernetesClientPodUtils;
import org.springframework.cloud.kubernetes.client.discovery.ConditionalOnSelectiveNamespacesMissing;
import org.springframework.cloud.kubernetes.client.discovery.ConditionalOnSelectiveNamespacesPresent;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientInformerAutoConfiguration;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientInformerSelectiveNamespacesAutoConfiguration;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesInformerDiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.reactive.KubernetesInformerReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.cloud.kubernetes.commons.discovery.ConditionalOnKubernetesDiscoveryEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryClientHealthIndicatorInitializer;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryPropertiesAutoConfiguration;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.log.LogAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnKubernetesDiscoveryEnabled
@ConditionalOnReactiveDiscoveryEnabled
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@AutoConfigureBefore(value={SimpleReactiveDiscoveryClientAutoConfiguration.class, ReactiveCommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={ReactiveCompositeDiscoveryClientAutoConfiguration.class, KubernetesDiscoveryPropertiesAutoConfiguration.class, KubernetesClientInformerAutoConfiguration.class, KubernetesClientInformerSelectiveNamespacesAutoConfiguration.class})
public class KubernetesInformerReactiveDiscoveryClientAutoConfiguration {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesInformerReactiveDiscoveryClientAutoConfiguration.class));

    @Deprecated(forRemoval=true)
    public ReactiveDiscoveryClientHealthIndicator kubernetesReactiveDiscoveryClientHealthIndicator(KubernetesInformerReactiveDiscoveryClient client, DiscoveryClientHealthIndicatorProperties properties, KubernetesClientPodUtils podUtils) {
        ReactiveDiscoveryClientHealthIndicator healthIndicator = new ReactiveDiscoveryClientHealthIndicator((ReactiveDiscoveryClient)client, properties);
        InstanceRegisteredEvent event = new InstanceRegisteredEvent((Object)new KubernetesDiscoveryClientHealthIndicatorInitializer.RegisteredEventSource("kubernetes", podUtils.isInsideKubernetes(), podUtils.currentPod().get()), null);
        healthIndicator.onApplicationEvent(event);
        return healthIndicator;
    }

    @Deprecated(forRemoval=true)
    public KubernetesInformerReactiveDiscoveryClient kubernetesReactiveDiscoveryClient(KubernetesNamespaceProvider kubernetesNamespaceProvider, SharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
        return new KubernetesInformerReactiveDiscoveryClient(kubernetesNamespaceProvider, sharedInformerFactory, serviceLister, endpointsLister, serviceInformer, endpointsInformer, properties);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.boot.actuate.health.ReactiveHealthIndicator"})
    @ConditionalOnDiscoveryHealthIndicatorEnabled
    KubernetesDiscoveryClientHealthIndicatorInitializer reactiveIndicatorInitializer(ApplicationEventPublisher applicationEventPublisher, PodUtils<?> podUtils) {
        LOG.debug(() -> "Will publish InstanceRegisteredEvent from reactive implementation");
        return new KubernetesDiscoveryClientHealthIndicatorInitializer(podUtils, applicationEventPublisher);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.boot.actuate.health.ReactiveHealthIndicator"})
    @ConditionalOnDiscoveryHealthIndicatorEnabled
    ReactiveDiscoveryClientHealthIndicator kubernetesReactiveDiscoveryClientHealthIndicator(KubernetesInformerReactiveDiscoveryClient client, DiscoveryClientHealthIndicatorProperties properties) {
        return new ReactiveDiscoveryClientHealthIndicator((ReactiveDiscoveryClient)client, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    KubernetesInformerReactiveDiscoveryClient kubernetesClientReactiveDiscoveryClient(KubernetesInformerDiscoveryClient kubernetesClientInformerDiscoveryClient) {
        return new KubernetesInformerReactiveDiscoveryClient(kubernetesClientInformerDiscoveryClient);
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={ConditionalOnSelectiveNamespacesMissing.class})
    KubernetesInformerDiscoveryClient kubernetesClientInformerDiscoveryClient(SharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
        return new KubernetesInformerDiscoveryClient(sharedInformerFactory, serviceLister, endpointsLister, serviceInformer, endpointsInformer, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={ConditionalOnSelectiveNamespacesPresent.class})
    KubernetesInformerDiscoveryClient selectiveNamespacesKubernetesClientInformerDiscoveryClient(List<SharedInformerFactory> sharedInformerFactories, List<Lister<V1Service>> serviceListers, List<Lister<V1Endpoints>> endpointsListers, List<SharedInformer<V1Service>> serviceInformers, List<SharedInformer<V1Endpoints>> endpointsInformers, KubernetesDiscoveryProperties properties) {
        return new KubernetesInformerDiscoveryClient(sharedInformerFactories, serviceListers, endpointsListers, serviceInformers, endpointsInformers, properties);
    }
}

