/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.extended.wait.Wait;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.models.CoreV1EndpointPort;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Service;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesDiscoveryClientUtils;
import org.springframework.cloud.kubernetes.commons.discovery.DefaultKubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class KubernetesInformerDiscoveryClient
implements DiscoveryClient {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesInformerDiscoveryClient.class));
    private final SharedInformerFactory sharedInformerFactory;
    private final Lister<V1Service> serviceLister;
    private final Supplier<Boolean> informersReadyFunc;
    private final Lister<V1Endpoints> endpointsLister;
    private final KubernetesDiscoveryProperties properties;
    private final String namespace;

    public KubernetesInformerDiscoveryClient(String namespace, SharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
        this.namespace = namespace;
        this.sharedInformerFactory = sharedInformerFactory;
        this.serviceLister = serviceLister;
        this.endpointsLister = endpointsLister;
        this.informersReadyFunc = () -> serviceInformer.hasSynced() && endpointsInformer.hasSynced();
        this.properties = properties;
    }

    public String description() {
        return "Fabric8 Kubernetes Client Discovery";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        List<V1Service> services;
        Objects.requireNonNull(serviceId, "serviceId must be provided");
        if (!StringUtils.hasText((String)this.namespace) && !this.properties.allNamespaces()) {
            LOG.warn(() -> "Namespace is null or empty, this may cause issues looking up services");
        }
        List<V1Service> list = services = this.properties.allNamespaces() ? this.serviceLister.list().stream().filter(svc -> serviceId.equals(svc.getMetadata().getName())).toList() : List.of((V1Service)this.serviceLister.namespace(this.namespace).get(serviceId));
        if (services.size() == 0 || !services.stream().anyMatch(service -> KubernetesDiscoveryClientUtils.matchesServiceLabels(service, this.properties))) {
            return new ArrayList<ServiceInstance>();
        }
        return services.stream().flatMap(s -> this.getServiceInstanceDetails((V1Service)s, serviceId)).toList();
    }

    private Stream<ServiceInstance> getServiceInstanceDetails(V1Service service, String serviceId) {
        V1Endpoints ep;
        HashMap svcMetadata = new HashMap();
        if (this.properties.metadata() != null) {
            if (this.properties.metadata().addLabels() && service.getMetadata() != null && service.getMetadata().getLabels() != null) {
                String labelPrefix = this.properties.metadata().labelsPrefix() != null ? this.properties.metadata().labelsPrefix() : "";
                service.getMetadata().getLabels().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(labelPrefix)).forEach(e -> svcMetadata.put((String)e.getKey(), (String)e.getValue()));
            }
            if (this.properties.metadata().addAnnotations() && service.getMetadata() != null && service.getMetadata().getAnnotations() != null) {
                String annotationPrefix = this.properties.metadata().annotationsPrefix() != null ? this.properties.metadata().annotationsPrefix() : "";
                service.getMetadata().getAnnotations().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(annotationPrefix)).forEach(e -> svcMetadata.put((String)e.getKey(), (String)e.getValue()));
            }
        }
        if ((ep = (V1Endpoints)this.endpointsLister.namespace(service.getMetadata().getNamespace()).get(service.getMetadata().getName())) == null || ep.getSubsets() == null) {
            return Stream.empty();
        }
        Optional<String> discoveredPrimaryPortName = Optional.empty();
        if (service.getMetadata() != null && service.getMetadata().getLabels() != null) {
            discoveredPrimaryPortName = Optional.ofNullable((String)service.getMetadata().getLabels().get("primary-port-name"));
        }
        String primaryPortName = discoveredPrimaryPortName.orElse(this.properties.primaryPortName());
        boolean secured = KubernetesInformerDiscoveryClient.isSecured(service);
        return ep.getSubsets().stream().filter(subset -> subset.getPorts() != null && subset.getPorts().size() > 0).flatMap(subset -> {
            ArrayList addresses;
            HashMap metadata = new HashMap(svcMetadata);
            List endpointPorts = subset.getPorts();
            if (this.properties.metadata() != null && this.properties.metadata().addPorts()) {
                endpointPorts.forEach(p -> metadata.put(StringUtils.hasText((String)p.getName()) ? p.getName() : "<unset>", Integer.toString(p.getPort())));
            }
            if ((addresses = subset.getAddresses()) == null) {
                addresses = new ArrayList();
            }
            if (this.properties.includeNotReadyAddresses() && !CollectionUtils.isEmpty((Collection)subset.getNotReadyAddresses())) {
                addresses.addAll(subset.getNotReadyAddresses());
            }
            int port = this.findEndpointPort(endpointPorts, primaryPortName, serviceId);
            return addresses.stream().map(addr -> new DefaultKubernetesServiceInstance(addr.getTargetRef() != null ? addr.getTargetRef().getUid() : "", serviceId, addr.getIp(), port, metadata, secured, service.getMetadata().getNamespace(), null));
        });
    }

    private static boolean isSecured(V1Service service) {
        Optional<String> securedOpt = Optional.empty();
        if (service.getMetadata() != null && service.getMetadata().getAnnotations() != null) {
            securedOpt = Optional.ofNullable((String)service.getMetadata().getAnnotations().get("secured"));
        }
        if (!securedOpt.isPresent() && service.getMetadata() != null && service.getMetadata().getLabels() != null) {
            securedOpt = Optional.ofNullable((String)service.getMetadata().getLabels().get("secured"));
        }
        return Boolean.parseBoolean(securedOpt.orElse("false"));
    }

    private int findEndpointPort(List<CoreV1EndpointPort> endpointPorts, String primaryPortName, String serviceId) {
        if (endpointPorts.size() == 1) {
            return endpointPorts.get(0).getPort();
        }
        Map<String, Integer> ports = endpointPorts.stream().filter(p -> StringUtils.hasText((String)p.getName())).collect(Collectors.toMap(CoreV1EndpointPort::getName, CoreV1EndpointPort::getPort));
        int discoveredPort = ports.getOrDefault(primaryPortName, ports.getOrDefault("https", ports.getOrDefault("http", -1)));
        if (discoveredPort == -1) {
            if (StringUtils.hasText((String)primaryPortName)) {
                LOG.warn(() -> "Could not find a port named '" + primaryPortName + "', 'https', or 'http' for service '" + serviceId + "'.");
            } else {
                LOG.warn(() -> "Could not find a port named 'https' or 'http' for service '" + serviceId + "'.");
            }
            LOG.warn(() -> "Make sure that either the primary-port-name label has been added to the service, or that spring.cloud.kubernetes.discovery.primary-port-name has been configured.");
            LOG.warn(() -> "Alternatively name the primary port 'https' or 'http'");
            LOG.warn(() -> "An incorrect configuration may result in non-deterministic behaviour.");
            discoveredPort = endpointPorts.get(0).getPort();
        }
        return discoveredPort;
    }

    public List<String> getServices() {
        List services = this.properties.allNamespaces() ? this.serviceLister.list() : this.serviceLister.namespace(this.namespace).list();
        return services.stream().filter(service -> KubernetesDiscoveryClientUtils.matchesServiceLabels(service, this.properties)).map(s -> s.getMetadata().getName()).collect(Collectors.toList());
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.sharedInformerFactory.startAllRegisteredInformers();
        if (!Wait.poll((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(this.properties.cacheLoadingTimeoutSeconds()), () -> {
            LOG.info(() -> "Waiting for the cache of informers to be fully loaded..");
            return this.informersReadyFunc.get();
        })) {
            if (this.properties.waitCacheReady()) {
                throw new IllegalStateException("Timeout waiting for informers cache to be ready, is the kubernetes service up?");
            }
            LOG.warn(() -> "Timeout waiting for informers cache to be ready, ignoring the failure because waitForInformerCacheReady property is false");
        }
        LOG.info(() -> "Cache fully loaded (total " + this.serviceLister.list().size() + " services) , discovery client is now available");
    }
}

