/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigContext;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSourcesBatchRead;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.ReadType;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=0)
public class KubernetesClientConfigMapPropertySourceLocator
extends ConfigMapPropertySourceLocator {
    private final CoreV1Api coreV1Api;
    private final KubernetesNamespaceProvider kubernetesNamespaceProvider;

    public KubernetesClientConfigMapPropertySourceLocator(CoreV1Api coreV1Api, ConfigMapConfigProperties properties, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        super(properties);
        this.coreV1Api = coreV1Api;
        this.kubernetesNamespaceProvider = kubernetesNamespaceProvider;
    }

    public PropertySource<?> locate(Environment environment) {
        PropertySource propertySource = super.locate(environment);
        KubernetesClientSourcesBatchRead.discardConfigMaps();
        return propertySource;
    }

    protected MapPropertySource getPropertySource(ConfigurableEnvironment environment, NormalizedSource source, ReadType readType) {
        String normalizedNamespace = source.namespace().orElse(null);
        String namespace = KubernetesClientUtils.getApplicationNamespace((String)normalizedNamespace, (String)source.target(), (KubernetesNamespaceProvider)this.kubernetesNamespaceProvider);
        KubernetesClientConfigContext context = new KubernetesClientConfigContext(this.coreV1Api, source, namespace, (Environment)environment, true, readType);
        return new KubernetesClientConfigMapPropertySource(context);
    }
}

