/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapsCache;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsCache;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.core.env.Environment;

public final class KubernetesClientConfigUtils {
    private static final Log LOG = LogFactory.getLog(KubernetesClientConfigUtils.class);
    private static final boolean DECODE = Boolean.FALSE;

    private KubernetesClientConfigUtils() {
    }

    public static Set<String> namespaces(KubernetesNamespaceProvider provider, ConfigReloadProperties properties, String target) {
        Set<String> namespaces = properties.namespaces();
        if (namespaces.isEmpty()) {
            namespaces = Set.of(KubernetesClientUtils.getApplicationNamespace(null, (String)target, (KubernetesNamespaceProvider)provider));
        }
        LOG.debug((Object)("informer namespaces : " + namespaces));
        return namespaces;
    }

    static MultipleSourcesContainer secretsDataByLabels(CoreV1Api coreV1Api, String namespace, Map<String, String> labels, Environment environment, Set<String> profiles) {
        List<StrippedSourceContainer> strippedSecrets = KubernetesClientConfigUtils.strippedSecrets(coreV1Api, namespace);
        if (strippedSecrets.isEmpty()) {
            return MultipleSourcesContainer.empty();
        }
        return ConfigUtils.processLabeledData(strippedSecrets, (Environment)environment, labels, (String)namespace, profiles, (boolean)DECODE);
    }

    static MultipleSourcesContainer configMapsDataByLabels(CoreV1Api coreV1Api, String namespace, Map<String, String> labels, Environment environment, Set<String> profiles) {
        List<StrippedSourceContainer> strippedConfigMaps = KubernetesClientConfigUtils.strippedConfigMaps(coreV1Api, namespace);
        if (strippedConfigMaps.isEmpty()) {
            return MultipleSourcesContainer.empty();
        }
        return ConfigUtils.processLabeledData(strippedConfigMaps, (Environment)environment, labels, (String)namespace, profiles, (boolean)DECODE);
    }

    static MultipleSourcesContainer secretsDataByName(CoreV1Api coreV1Api, String namespace, LinkedHashSet<String> sourceNames, Environment environment, boolean includeDefaultProfileData) {
        List<StrippedSourceContainer> strippedSecrets = KubernetesClientConfigUtils.strippedSecrets(coreV1Api, namespace);
        if (strippedSecrets.isEmpty()) {
            return MultipleSourcesContainer.empty();
        }
        return ConfigUtils.processNamedData(strippedSecrets, (Environment)environment, sourceNames, (String)namespace, (boolean)DECODE, (boolean)includeDefaultProfileData);
    }

    static MultipleSourcesContainer configMapsDataByName(CoreV1Api coreV1Api, String namespace, LinkedHashSet<String> sourceNames, Environment environment, boolean includeDefaultProfileData) {
        List<StrippedSourceContainer> strippedConfigMaps = KubernetesClientConfigUtils.strippedConfigMaps(coreV1Api, namespace);
        if (strippedConfigMaps.isEmpty()) {
            return MultipleSourcesContainer.empty();
        }
        return ConfigUtils.processNamedData(strippedConfigMaps, (Environment)environment, sourceNames, (String)namespace, (boolean)DECODE, (boolean)includeDefaultProfileData);
    }

    private static List<StrippedSourceContainer> strippedConfigMaps(CoreV1Api coreV1Api, String namespace) {
        List<StrippedSourceContainer> strippedConfigMaps = KubernetesClientConfigMapsCache.byNamespace(coreV1Api, namespace);
        if (strippedConfigMaps.isEmpty()) {
            LOG.debug((Object)("No configmaps in namespace '" + namespace + "'"));
        }
        return strippedConfigMaps;
    }

    private static List<StrippedSourceContainer> strippedSecrets(CoreV1Api coreV1Api, String namespace) {
        List<StrippedSourceContainer> strippedSecrets = KubernetesClientSecretsCache.byNamespace(coreV1Api, namespace);
        if (strippedSecrets.isEmpty()) {
            LOG.debug((Object)("No secrets in namespace '" + namespace + "'"));
        }
        return strippedSecrets;
    }
}

