/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config.reload;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretList;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadUtil;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.log.LogAccessor;

public class KubernetesClientEventBasedSecretsChangeDetector
extends ConfigurationChangeDetector {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientEventBasedSecretsChangeDetector.class));
    private final CoreV1Api coreV1Api;
    private final KubernetesClientSecretsPropertySourceLocator propertySourceLocator;
    private final SharedInformerFactory factory;
    private final List<SharedIndexInformer<V1Secret>> informers = new ArrayList<SharedIndexInformer<V1Secret>>();
    private final Set<String> namespaces;
    private final boolean enableReloadFiltering;
    private final ResourceEventHandler<V1Secret> handler = new ResourceEventHandler<V1Secret>(){

        public void onAdd(V1Secret secret) {
            LOG.debug(() -> "Secret " + secret.getMetadata().getName() + " was added.");
            KubernetesClientEventBasedSecretsChangeDetector.this.onEvent((KubernetesObject)secret);
        }

        public void onUpdate(V1Secret oldSecret, V1Secret newSecret) {
            LOG.debug(() -> "Secret " + newSecret.getMetadata().getName() + " was updated.");
            KubernetesClientEventBasedSecretsChangeDetector.this.onEvent((KubernetesObject)newSecret);
        }

        public void onDelete(V1Secret secret, boolean deletedFinalStateUnknown) {
            LOG.debug(() -> "Secret " + secret.getMetadata().getName() + " was deleted.");
            KubernetesClientEventBasedSecretsChangeDetector.this.onEvent((KubernetesObject)secret);
        }
    };

    public KubernetesClientEventBasedSecretsChangeDetector(CoreV1Api coreV1Api, ConfigurableEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientSecretsPropertySourceLocator propertySourceLocator, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        super(environment, properties, strategy);
        this.propertySourceLocator = propertySourceLocator;
        this.coreV1Api = coreV1Api;
        this.factory = new SharedInformerFactory(KubernetesClientUtils.createApiClientForInformerClient());
        this.enableReloadFiltering = properties.enableReloadFiltering();
        this.namespaces = KubernetesClientConfigUtils.namespaces(kubernetesNamespaceProvider, properties, "secret");
    }

    @PostConstruct
    void inform() {
        LOG.info(() -> "Kubernetes event-based secrets change detector activated");
        this.namespaces.forEach(namespace -> {
            String filter = null;
            if (this.enableReloadFiltering) {
                filter = "spring.cloud.kubernetes.config.informer.enabled=true";
                LOG.debug(() -> "added secret informer for namespace : " + namespace + " with enabled filter");
            } else {
                LOG.debug(() -> "added secret informer for namespace : " + namespace);
            }
            String filterOnInformerLabel = filter;
            SharedIndexInformer informer = this.factory.sharedIndexInformerFor(params -> this.coreV1Api.listNamespacedSecretCall(namespace, null, null, null, null, filterOnInformerLabel, null, params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1Secret.class, V1SecretList.class);
            informer.addEventHandler(this.handler);
            this.informers.add((SharedIndexInformer<V1Secret>)informer);
        });
        this.factory.startAllRegisteredInformers();
    }

    @PreDestroy
    void shutdown() {
        this.informers.forEach(SharedInformer::stop);
        this.factory.stopAllRegisteredInformers();
    }

    protected void onEvent(KubernetesObject secret) {
        boolean reload = ConfigReloadUtil.reload((String)"secrets", (String)secret.toString(), (PropertySourceLocator)this.propertySourceLocator, (ConfigurableEnvironment)this.environment, KubernetesClientSecretsPropertySource.class);
        if (reload) {
            this.reloadProperties();
        }
    }
}

