/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client;

import io.kubernetes.client.openapi.models.V1Pod;
import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.cloud.kubernetes.client.KubernetesClientHealthIndicator;
import org.springframework.cloud.kubernetes.client.KubernetesClientInfoContributor;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.cloud.kubernetes.commons.autoconfig.ConditionalOnKubernetesHealthIndicatorEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesHealthIndicatorEnabled
final class KubernetesClientActuatorConfiguration {
    KubernetesClientActuatorConfiguration() {
    }

    @Bean
    @ConditionalOnEnabledHealthIndicator(value="kubernetes")
    KubernetesClientHealthIndicator kubernetesHealthIndicator(PodUtils<V1Pod> podUtils) {
        return new KubernetesClientHealthIndicator(podUtils);
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="kubernetes")
    KubernetesClientInfoContributor kubernetesInfoContributor(PodUtils<V1Pod> podUtils) {
        return new KubernetesClientInfoContributor(podUtils);
    }
}

