/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Pod;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.LazilyInstantiate;
import org.springframework.cloud.kubernetes.commons.PodUtils;

public class KubernetesClientPodUtils
implements PodUtils<V1Pod> {
    public static final String HOSTNAME = "HOSTNAME";
    private static final Log LOG = LogFactory.getLog(KubernetesClientPodUtils.class);
    private final CoreV1Api client;
    private final String hostName;
    private Supplier<V1Pod> current;
    private String namespace;

    public KubernetesClientPodUtils(CoreV1Api client, String namespace) {
        if (client == null) {
            throw new IllegalArgumentException("Must provide an instance of KubernetesClient");
        }
        this.client = client;
        this.hostName = System.getenv(HOSTNAME);
        this.current = LazilyInstantiate.using(() -> this.internalGetPod());
        this.namespace = namespace;
    }

    public Supplier<V1Pod> currentPod() {
        return this.current;
    }

    public Boolean isInsideKubernetes() {
        return this.currentPod().get() != null;
    }

    private synchronized V1Pod internalGetPod() {
        try {
            LOG.info((Object)"Getting pod internal");
            if (this.isServiceAccountFound() && this.isHostNameEnvVarPresent()) {
                return this.client.readNamespacedPod(this.hostName, this.namespace, null, null, null);
            }
            return null;
        }
        catch (Throwable t) {
            LOG.warn((Object)("Failed to get pod with name:[" + this.hostName + "]. You should look into this if things aren't working as you expect. Are you missing serviceaccount permissions?"), t);
            return null;
        }
    }

    private boolean isHostNameEnvVarPresent() {
        return this.hostName != null && !this.hostName.isEmpty();
    }

    private boolean isServiceAccountFound() {
        return Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0]).toFile().exists() && Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt", new String[0]).toFile().exists();
    }
}

