/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client;

import io.kubernetes.client.openapi.models.V1Pod;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.kubernetes.commons.AbstractKubernetesInfoContributor;
import org.springframework.cloud.kubernetes.commons.PodUtils;

public class KubernetesClientInfoContributor
extends AbstractKubernetesInfoContributor {
    private PodUtils<V1Pod> utils;

    public KubernetesClientInfoContributor(PodUtils<V1Pod> utils) {
        this.utils = utils;
    }

    public Map<String, Object> getDetails() {
        V1Pod current = (V1Pod)this.utils.currentPod().get();
        HashMap<String, Object> details = new HashMap<String, Object>();
        boolean inside = current != null;
        details.put("inside", inside);
        if (inside) {
            details.put("namespace", current.getMetadata().getNamespace());
            details.put("podName", current.getMetadata().getName());
            details.put("podIp", current.getStatus().getPodIP());
            details.put("serviceAccount", current.getSpec().getServiceAccountName());
            details.put("nodeName", current.getSpec().getNodeName());
            details.put("hostIp", current.getStatus().getHostIP());
        }
        return details;
    }
}

