/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client;

import io.kubernetes.client.openapi.models.V1Pod;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.kubernetes.commons.AbstractKubernetesHealthIndicator;
import org.springframework.cloud.kubernetes.commons.PodUtils;

public class KubernetesClientHealthIndicator
extends AbstractKubernetesHealthIndicator {
    private PodUtils<V1Pod> utils;

    public KubernetesClientHealthIndicator(PodUtils<V1Pod> utils) {
        this.utils = utils;
    }

    protected Map<String, Object> getDetails() throws Exception {
        HashMap<String, Object> details = new HashMap<String, Object>();
        V1Pod current = (V1Pod)this.utils.currentPod().get();
        if (current != null) {
            details.put("inside", true);
            details.put("namespace", current.getMetadata().getNamespace());
            details.put("podName", current.getMetadata().getName());
            details.put("podIp", current.getStatus().getPodIP());
            details.put("serviceAccount", current.getSpec().getServiceAccountName());
            details.put("nodeName", current.getSpec().getNodeName());
            details.put("hostIp", current.getStatus().getHostIP());
            details.put("labels", current.getMetadata().getLabels());
        } else {
            details.put("inside", false);
        }
        return details;
    }
}

