/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.vision;

import com.google.cloud.storage.Blob;
import com.google.cloud.vision.v1.TextAnnotation;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.springframework.cloud.gcp.vision.OcrPageRange;

public class DocumentOcrResultSet {
    private final TreeMap<Integer, OcrPageRange> ocrPageRanges = new TreeMap();
    private final int minPage;
    private final int maxPage;

    DocumentOcrResultSet(Collection<Blob> pages) {
        for (Blob blob : pages) {
            OcrPageRange pageRange = new OcrPageRange(blob);
            this.ocrPageRanges.put(pageRange.getStartPage(), pageRange);
        }
        this.minPage = this.ocrPageRanges.firstEntry().getValue().getStartPage();
        this.maxPage = this.ocrPageRanges.lastEntry().getValue().getEndPage();
    }

    public int getMinPage() {
        return this.minPage;
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public TextAnnotation getPage(int pageNumber) throws InvalidProtocolBufferException {
        if (pageNumber < this.minPage || pageNumber > this.maxPage) {
            throw new IndexOutOfBoundsException("Page number out of bounds: " + pageNumber);
        }
        OcrPageRange pageRange = this.ocrPageRanges.floorEntry(pageNumber).getValue();
        return pageRange.getPage(pageNumber);
    }

    public Iterator<TextAnnotation> getAllPages() {
        return new Iterator<TextAnnotation>(){
            private final Iterator<OcrPageRange> pageRangeIterator;
            private int offset;
            private List<TextAnnotation> currentPageRange;
            {
                this.pageRangeIterator = DocumentOcrResultSet.this.ocrPageRanges.values().iterator();
                this.offset = 0;
                this.currentPageRange = Collections.EMPTY_LIST;
            }

            @Override
            public boolean hasNext() {
                return this.pageRangeIterator.hasNext() || this.offset < this.currentPageRange.size();
            }

            @Override
            public TextAnnotation next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more pages left in DocumentOcrResultSet.");
                }
                if (this.offset >= this.currentPageRange.size()) {
                    OcrPageRange pageRange = this.pageRangeIterator.next();
                    this.offset = 0;
                    try {
                        this.currentPageRange = pageRange.getPages();
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new RuntimeException("Failed to parse OCR output from JSON output file " + pageRange.getBlob().getName(), e);
                    }
                }
                TextAnnotation result = this.currentPageRange.get(this.offset);
                ++this.offset;
                return result;
            }
        };
    }
}

