/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.security.iap;

import com.google.cloud.resourcemanager.Project;
import com.google.cloud.resourcemanager.ResourceManager;
import com.google.cloud.resourcemanager.ResourceManagerOptions;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.security.iap.AudienceProvider;
import org.springframework.util.Assert;

public class AppEngineAudienceProvider
implements AudienceProvider {
    private static final String AUDIENCE_FORMAT = "/projects/%s/apps/%s";
    private final GcpProjectIdProvider projectIdProvider;
    private ResourceManager resourceManager = (ResourceManager)ResourceManagerOptions.getDefaultInstance().getService();

    public AppEngineAudienceProvider(GcpProjectIdProvider projectIdProvider) {
        Assert.notNull((Object)projectIdProvider, (String)"GcpProjectIdProvider cannot be null.");
        this.projectIdProvider = projectIdProvider;
    }

    @Override
    public String getAudience() {
        Project project = this.resourceManager.get(this.projectIdProvider.getProjectId(), new ResourceManager.ProjectGetOption[0]);
        Assert.notNull((Object)project, (String)"Project expected not to be null. Is Cloud Resource Manager API enabled? (https://console.developers.google.com/apis/api/cloudresourcemanager.googleapis.com)");
        Assert.notNull((Object)project.getProjectNumber(), (String)"Project Number expected not to be null.");
        String projectId = this.projectIdProvider.getProjectId();
        Assert.notNull((Object)projectId, (String)"Project Id expected not to be null.");
        return String.format(AUDIENCE_FORMAT, project.getProjectNumber(), projectId);
    }

    public void setResourceManager(ResourceManager resourceManager) {
        Assert.notNull((Object)resourceManager, (String)"ResourceManager cannot be null.");
        this.resourceManager = resourceManager;
    }
}

