/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.security.iap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.gcp.security.iap.AudienceProvider;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public class AudienceValidator
implements OAuth2TokenValidator<Jwt>,
InitializingBean {
    private static final Log LOGGER = LogFactory.getLog(AudienceValidator.class);
    private static final OAuth2Error INVALID_AUDIENCE = new OAuth2Error("invalid_request", "This aud claim is not equal to the configured audience", "https://tools.ietf.org/html/rfc6750#section-3.1");
    private final AudienceProvider audienceProvider;
    private String audience;

    public AudienceValidator(AudienceProvider audienceProvider) {
        Assert.notNull((Object)audienceProvider, (String)"Audience Provider cannot be null");
        this.audienceProvider = audienceProvider;
    }

    public OAuth2TokenValidatorResult validate(Jwt t) {
        if (t.getAudience() != null && t.getAudience().contains(this.audience)) {
            return OAuth2TokenValidatorResult.success();
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn((Object)String.format("Expected audience %s did not match token audience %s", this.audience, t.getAudience()));
        }
        return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{INVALID_AUDIENCE});
    }

    public void afterPropertiesSet() throws Exception {
        this.audience = this.audienceProvider.getAudience();
        Assert.notNull((Object)this.audience, (String)"Audience cannot be null.");
    }

    public String getAudience() {
        return this.audience;
    }
}

