/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.api.core.ApiFuture;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpannerTransactionManager
extends AbstractPlatformTransactionManager {
    private final Supplier<DatabaseClient> databaseClientProvider;

    public SpannerTransactionManager(Supplier databaseClientProvider) {
        this.databaseClientProvider = databaseClientProvider;
    }

    protected Object doGetTransaction() throws TransactionException {
        Tx tx = (Tx)TransactionSynchronizationManager.getResource((Object)this.databaseClientProvider.get());
        if (tx != null && tx.getTransactionContext() != null && (tx.getTransactionManager() != null && tx.getTransactionManager().getState() == TransactionManager.TransactionState.STARTED || tx.isReadOnly())) {
            return tx;
        }
        return new Tx(this.databaseClientProvider.get());
    }

    protected void doBegin(Object transactionObject, TransactionDefinition transactionDefinition) throws TransactionException {
        if (transactionDefinition.getIsolationLevel() != -1) {
            throw new IllegalStateException("SpannerTransactionManager supports only isolation level TransactionDefinition.ISOLATION_DEFAULT");
        }
        if (transactionDefinition.getPropagationBehavior() != 0) {
            throw new IllegalStateException("SpannerTransactionManager supports only propagation behavior TransactionDefinition.PROPAGATION_REQUIRED");
        }
        Tx tx = (Tx)transactionObject;
        if (transactionDefinition.isReadOnly()) {
            ReadOnlyTransaction targetTransactionContext = this.databaseClientProvider.get().readOnlyTransaction();
            tx.isReadOnly = true;
            tx.transactionManager = null;
            tx.transactionContext = new TransactionContext((ReadContext)targetTransactionContext){
                final /* synthetic */ ReadContext val$targetTransactionContext;
                {
                    this.val$targetTransactionContext = readContext;
                }

                public void buffer(Mutation mutation) {
                    throw new IllegalStateException("Spanner transaction cannot apply mutation because it is in readonly mode");
                }

                public void buffer(Iterable<Mutation> iterable) {
                    throw new IllegalStateException("Spanner transaction cannot apply mutations because it is in readonly mode");
                }

                public long executeUpdate(Statement statement) {
                    throw new IllegalStateException("Spanner transaction cannot execute DML because it is in readonly mode");
                }

                public ApiFuture<Long> executeUpdateAsync(Statement statement) {
                    throw new IllegalStateException("Spanner transaction cannot execute DML because it is in readonly mode");
                }

                public long[] batchUpdate(Iterable<Statement> iterable) {
                    throw new IllegalStateException("Spanner transaction cannot execute DML because it is in readonly mode");
                }

                public ApiFuture<long[]> batchUpdateAsync(Iterable<Statement> iterable) {
                    throw new IllegalStateException("Spanner transaction cannot execute DML because it is in readonly mode");
                }

                public ResultSet read(String s, KeySet keySet, Iterable<String> iterable, Options.ReadOption ... readOptions) {
                    return this.val$targetTransactionContext.read(s, keySet, iterable, readOptions);
                }

                public AsyncResultSet readAsync(String s, KeySet keySet, Iterable<String> iterable, Options.ReadOption ... readOptions) {
                    return this.val$targetTransactionContext.readAsync(s, keySet, iterable, readOptions);
                }

                public ResultSet readUsingIndex(String s, String s1, KeySet keySet, Iterable<String> iterable, Options.ReadOption ... readOptions) {
                    return this.val$targetTransactionContext.readUsingIndex(s, s1, keySet, iterable, readOptions);
                }

                public AsyncResultSet readUsingIndexAsync(String s, String s1, KeySet keySet, Iterable<String> iterable, Options.ReadOption ... readOptions) {
                    return this.val$targetTransactionContext.readUsingIndexAsync(s, s1, keySet, iterable, readOptions);
                }

                @Nullable
                public Struct readRow(String s, Key key, Iterable<String> iterable) {
                    return this.val$targetTransactionContext.readRow(s, key, iterable);
                }

                public ApiFuture<Struct> readRowAsync(String s, Key key, Iterable<String> iterable) {
                    return this.val$targetTransactionContext.readRowAsync(s, key, iterable);
                }

                @Nullable
                public Struct readRowUsingIndex(String s, String s1, Key key, Iterable<String> iterable) {
                    return this.val$targetTransactionContext.readRowUsingIndex(s, s1, key, iterable);
                }

                public ApiFuture<Struct> readRowUsingIndexAsync(String s, String s1, Key key, Iterable<String> iterable) {
                    return this.val$targetTransactionContext.readRowUsingIndexAsync(s, s1, key, iterable);
                }

                public ResultSet executeQuery(Statement statement, Options.QueryOption ... queryOptions) {
                    return this.val$targetTransactionContext.executeQuery(statement, queryOptions);
                }

                public AsyncResultSet executeQueryAsync(Statement statement, Options.QueryOption ... queryOptions) {
                    return this.val$targetTransactionContext.executeQueryAsync(statement, queryOptions);
                }

                public ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode queryAnalyzeMode) {
                    return this.val$targetTransactionContext.analyzeQuery(statement, queryAnalyzeMode);
                }

                public void close() {
                    this.val$targetTransactionContext.close();
                }
            };
        } else {
            tx.transactionManager = tx.databaseClient.transactionManager();
            tx.transactionContext = tx.getTransactionManager().begin();
            tx.isReadOnly = false;
        }
        TransactionSynchronizationManager.bindResource((Object)tx.getDatabaseClient(), (Object)tx);
    }

    protected void doCommit(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        Tx tx = (Tx)defaultTransactionStatus.getTransaction();
        try {
            if (tx.getTransactionManager() != null && tx.getTransactionManager().getState() == TransactionManager.TransactionState.STARTED) {
                tx.getTransactionManager().commit();
            }
            if (tx.isReadOnly()) {
                tx.getTransactionContext().close();
            }
        }
        catch (AbortedException ex) {
            throw new UnexpectedRollbackException("Transaction Got Rolled Back", (Throwable)ex);
        }
        catch (SpannerException ex) {
            throw this.makeDataIntegrityViolationException(ex);
        }
    }

    private RuntimeException makeDataIntegrityViolationException(SpannerException e) {
        switch (e.getErrorCode()) {
            case ALREADY_EXISTS: {
                return new DuplicateKeyException(e.getErrorCode().toString(), (Throwable)e);
            }
        }
        return e;
    }

    protected void doRollback(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        Tx tx = (Tx)defaultTransactionStatus.getTransaction();
        if (tx.getTransactionManager() != null && tx.getTransactionManager().getState() == TransactionManager.TransactionState.STARTED) {
            tx.getTransactionManager().rollback();
        }
        if (tx.isReadOnly()) {
            tx.getTransactionContext().close();
        }
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((Tx)transaction).getTransactionContext() != null;
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        Tx tx = (Tx)transaction;
        TransactionSynchronizationManager.unbindResource((Object)tx.getDatabaseClient());
        tx.transactionManager = null;
        tx.transactionContext = null;
        tx.isReadOnly = false;
    }

    public static class Tx {
        TransactionManager transactionManager;
        TransactionContext transactionContext;
        boolean isReadOnly;
        DatabaseClient databaseClient;

        public Tx(DatabaseClient databaseClient) {
            this.databaseClient = databaseClient;
        }

        public TransactionContext getTransactionContext() {
            return this.transactionContext;
        }

        public TransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public DatabaseClient getDatabaseClient() {
            return this.databaseClient;
        }
    }
}

