/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.convert;

import com.google.cloud.spanner.Struct;
import java.util.Set;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerEntityReader;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerReadConverter;
import org.springframework.cloud.gcp.data.spanner.core.convert.StructAccessor;
import org.springframework.cloud.gcp.data.spanner.core.convert.StructPropertyValueProvider;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;

class ConverterAwareMappingSpannerEntityReader
implements SpannerEntityReader {
    private final SpannerMappingContext spannerMappingContext;
    private EntityInstantiators instantiators;
    private SpannerReadConverter converter;

    ConverterAwareMappingSpannerEntityReader(SpannerMappingContext spannerMappingContext, SpannerReadConverter spannerReadConverter) {
        this.spannerMappingContext = spannerMappingContext;
        this.instantiators = new EntityInstantiators();
        this.converter = spannerReadConverter;
    }

    @Override
    public <R> R read(Class<R> type, Struct source, Set<String> includeColumns, boolean allowMissingColumns) {
        boolean readAllColumns = includeColumns == null;
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.spannerMappingContext.getPersistentEntity(type);
        StructAccessor structAccessor = new StructAccessor(source);
        StructPropertyValueProvider propertyValueProvider = new StructPropertyValueProvider(structAccessor, this.converter, this, allowMissingColumns);
        PreferredConstructor persistenceConstructor = persistentEntity.getPersistenceConstructor();
        PersistentEntityParameterValueProvider parameterValueProvider = new PersistentEntityParameterValueProvider((PersistentEntity)persistentEntity, (PropertyValueProvider)propertyValueProvider, null);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor((PersistentEntity)persistentEntity);
        Object instance = instantiator.createInstance((PersistentEntity)persistentEntity, (ParameterValueProvider)parameterValueProvider);
        PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(instance);
        persistentEntity.doWithProperties(spannerPersistentProperty -> {
            if (spannerPersistentProperty.isEmbedded()) {
                accessor.setProperty(spannerPersistentProperty, this.read(spannerPersistentProperty.getType(), source, includeColumns, allowMissingColumns));
            } else if (!this.shouldSkipProperty(structAccessor, (SpannerPersistentProperty)spannerPersistentProperty, includeColumns, readAllColumns, allowMissingColumns, (PreferredConstructor<?, SpannerPersistentProperty>)persistenceConstructor)) {
                Object value = propertyValueProvider.getPropertyValue((SpannerPersistentProperty)spannerPersistentProperty);
                accessor.setProperty(spannerPersistentProperty, value);
            }
        });
        return (R)instance;
    }

    private boolean shouldSkipProperty(StructAccessor struct, SpannerPersistentProperty spannerPersistentProperty, Set<String> includeColumns, boolean readAllColumns, boolean allowMissingColumns, PreferredConstructor<?, SpannerPersistentProperty> persistenceConstructor) {
        String columnName = spannerPersistentProperty.getColumnName();
        boolean notRequiredByPartialRead = !readAllColumns && !includeColumns.contains(columnName);
        return spannerPersistentProperty.isLazyInterleaved() || notRequiredByPartialRead || this.isMissingColumn(struct, allowMissingColumns, columnName) || struct.isNull(columnName) || persistenceConstructor.isConstructorParameter((PersistentProperty)spannerPersistentProperty);
    }

    private boolean isMissingColumn(StructAccessor struct, boolean allowMissingColumns, String columnName) {
        boolean missingColumn;
        boolean bl = missingColumn = !struct.hasColumn(columnName);
        if (missingColumn && !allowMissingColumns) {
            throw new SpannerDataException("Unable to read column from Cloud Spanner results: " + columnName);
        }
        return missingColumn;
    }
}

