/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.convert;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.gcp.core.util.MapBuilder;

public final class SpannerTypeMapper {
    private static final Map<Class, Type.Code> JAVA_TYPE_TO_SPANNER_SIMPLE_COLUMN_TYPE_MAPPING;
    private static final Map<Class, Type.Code> JAVA_TYPE_TO_SPANNER_ARRAY_COLUMN_TYPE_MAPPING;
    private static final Map<Type.Code, Class> SPANNER_SIMPLE_COLUMN_CODES_TO_JAVA_TYPE_MAPPING;
    private static final Map<Type.Code, Class> SPANNER_ARRAY_COLUMN_CODES_TO_JAVA_TYPE_MAPPING;

    private SpannerTypeMapper() {
    }

    public static Class getSimpleJavaClassFor(Type.Code code) {
        return SPANNER_SIMPLE_COLUMN_CODES_TO_JAVA_TYPE_MAPPING.get(code);
    }

    public static Class getArrayJavaClassFor(Type.Code code) {
        return SPANNER_ARRAY_COLUMN_CODES_TO_JAVA_TYPE_MAPPING.get(code);
    }

    public static Type.Code getSimpleTypeCodeForJavaType(Class spannerJavaType) {
        return JAVA_TYPE_TO_SPANNER_SIMPLE_COLUMN_TYPE_MAPPING.get(spannerJavaType);
    }

    public static Type.Code getArrayTypeCodeForJavaType(Class spannerJavaType) {
        return JAVA_TYPE_TO_SPANNER_ARRAY_COLUMN_TYPE_MAPPING.get(spannerJavaType);
    }

    static {
        SPANNER_SIMPLE_COLUMN_CODES_TO_JAVA_TYPE_MAPPING = new MapBuilder().put((Object)Type.Code.BOOL, Boolean.class).put((Object)Type.Code.BYTES, ByteArray.class).put((Object)Type.Code.DATE, Date.class).put((Object)Type.Code.FLOAT64, Double.class).put((Object)Type.Code.INT64, Long.class).put((Object)Type.Code.STRING, String.class).put((Object)Type.Code.STRUCT, Struct.class).put((Object)Type.Code.TIMESTAMP, Timestamp.class).build();
        SPANNER_ARRAY_COLUMN_CODES_TO_JAVA_TYPE_MAPPING = new MapBuilder().put((Object)Type.Code.BOOL, boolean[].class).put((Object)Type.Code.BYTES, ByteArray[].class).put((Object)Type.Code.DATE, Date[].class).put((Object)Type.Code.FLOAT64, double[].class).put((Object)Type.Code.INT64, long[].class).put((Object)Type.Code.STRING, String[].class).put((Object)Type.Code.STRUCT, Struct[].class).put((Object)Type.Code.TIMESTAMP, Timestamp[].class).build();
        HashMap<Class<Number>, Type.Code> builderMap = new HashMap<Class<Number>, Type.Code>();
        SPANNER_SIMPLE_COLUMN_CODES_TO_JAVA_TYPE_MAPPING.keySet().stream().forEach(type -> builderMap.put(SPANNER_SIMPLE_COLUMN_CODES_TO_JAVA_TYPE_MAPPING.get(type), (Type.Code)type));
        builderMap.put(Double.TYPE, Type.Code.FLOAT64);
        builderMap.put(Long.TYPE, Type.Code.INT64);
        JAVA_TYPE_TO_SPANNER_SIMPLE_COLUMN_TYPE_MAPPING = Collections.unmodifiableMap(builderMap);
        builderMap = new HashMap();
        SPANNER_ARRAY_COLUMN_CODES_TO_JAVA_TYPE_MAPPING.keySet().stream().forEach(type -> builderMap.put(SPANNER_ARRAY_COLUMN_CODES_TO_JAVA_TYPE_MAPPING.get(type), (Type.Code)type));
        JAVA_TYPE_TO_SPANNER_ARRAY_COLUMN_TYPE_MAPPING = Collections.unmodifiableMap(builderMap);
    }
}

