/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.convert;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.ValueBinder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.springframework.cloud.gcp.data.spanner.core.convert.ConversionUtils;
import org.springframework.cloud.gcp.data.spanner.core.convert.MultipleValueBinder;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerEntityWriter;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerTypeMapper;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerWriteConverter;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.util.Assert;

public class ConverterAwareMappingSpannerEntityWriter
implements SpannerEntityWriter {
    private static final Set<Class> SPANNER_KEY_COMPATIBLE_TYPES = ImmutableSet.builder().add(Boolean.class).add(Integer.class).add(Long.class).add(Float.class).add(Double.class).add(String.class).add(ByteArray.class).add(Timestamp.class).add(Date.class).build();
    public static final Map<Class<?>, BiFunction<ValueBinder, ?, ?>> singleItemTypeValueBinderMethodMap;
    static final Map<Class<?>, BiConsumer<ValueBinder<?>, Iterable>> iterablePropertyType2ToMethodMap;
    private final SpannerMappingContext spannerMappingContext;
    private final SpannerWriteConverter writeConverter;

    private static Map<Class<?>, BiConsumer<ValueBinder<?>, Iterable>> createIterableTypeMapping() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put(Date.class, ValueBinder::toDateArray);
        builder.put(Boolean.class, ValueBinder::toBoolArray);
        builder.put(Long.class, ValueBinder::toInt64Array);
        builder.put(String.class, ValueBinder::toStringArray);
        builder.put(Double.class, ValueBinder::toFloat64Array);
        builder.put(Timestamp.class, ValueBinder::toTimestampArray);
        builder.put(ByteArray.class, ValueBinder::toBytesArray);
        return builder.build();
    }

    ConverterAwareMappingSpannerEntityWriter(SpannerMappingContext spannerMappingContext, SpannerWriteConverter writeConverter) {
        this.spannerMappingContext = spannerMappingContext;
        this.writeConverter = writeConverter;
    }

    public static Class<?> findFirstCompatibleSpannerSingleItemNativeType(Predicate<Class> testFunc) {
        Optional<Class> compatible = singleItemTypeValueBinderMethodMap.keySet().stream().filter(testFunc).findFirst();
        return compatible.isPresent() ? compatible.get() : null;
    }

    public static Class<?> findFirstCompatibleSpannerMultupleItemNativeType(Predicate<Class> testFunc) {
        Optional<Class> compatible = iterablePropertyType2ToMethodMap.keySet().stream().filter(testFunc).findFirst();
        return compatible.isPresent() ? compatible.get() : null;
    }

    public void write(Object source, MultipleValueBinder sink) {
        this.write(source, sink, null);
    }

    @Override
    public void write(Object source, MultipleValueBinder sink, Set<String> includeColumns) {
        boolean writeAllColumns = includeColumns == null;
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.spannerMappingContext.getPersistentEntity(source.getClass());
        PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(source);
        persistentEntity.doWithColumnBackedProperties((PropertyHandler<SpannerPersistentProperty>)((PropertyHandler)spannerPersistentProperty -> {
            if (spannerPersistentProperty.isEmbedded()) {
                Object embeddedObject = accessor.getProperty(spannerPersistentProperty);
                if (embeddedObject != null) {
                    this.write(embeddedObject, sink, includeColumns);
                }
            } else if (writeAllColumns || includeColumns.contains(spannerPersistentProperty.getColumnName())) {
                this.writeProperty(sink, accessor, (SpannerPersistentProperty)spannerPersistentProperty);
            }
        }));
    }

    @Override
    public Key convertToKey(Object key) {
        Key k;
        Assert.notNull((Object)key, (String)"Key of an entity to be written cannot be null!");
        boolean isIterable = Iterable.class.isAssignableFrom(key.getClass());
        boolean isArray = Object[].class.isAssignableFrom(key.getClass());
        if ((isIterable || isArray) && !ByteArray.class.isAssignableFrom(key.getClass())) {
            Key.Builder kb = Key.newBuilder();
            for (Object t : isArray ? Arrays.asList((Object[])key) : (List<Object>)key) {
                kb.appendObject(this.convertKeyPart(t));
            }
            k = kb.build();
            if (k.size() == 0) {
                throw new SpannerDataException("A key must have at least one component, but 0 were given.");
            }
        } else {
            k = Key.class.isAssignableFrom(key.getClass()) ? (Key)key : Key.of((Object[])new Object[]{this.convertKeyPart(key)});
        }
        return k;
    }

    @Override
    public SpannerWriteConverter getSpannerWriteConverter() {
        return this.writeConverter;
    }

    private Object convertKeyPart(Object object) {
        if (object == null || this.isValidSpannerKeyType(ConversionUtils.boxIfNeeded(object.getClass()))) {
            return object;
        }
        Class<?> compatible = ConverterAwareMappingSpannerEntityWriter.findFirstCompatibleSpannerSingleItemNativeType(spannerType -> this.isValidSpannerKeyType((Class)spannerType) && this.writeConverter.canConvert(object.getClass(), (Class<?>)spannerType));
        if (compatible == null) {
            throw new SpannerDataException("The given object type couldn't be built into a Cloud Spanner Key: " + object.getClass());
        }
        return this.writeConverter.convert(object, compatible);
    }

    private boolean isValidSpannerKeyType(Class type) {
        return SPANNER_KEY_COMPATIBLE_TYPES.contains(type);
    }

    private void writeProperty(MultipleValueBinder sink, PersistentPropertyAccessor accessor, SpannerPersistentProperty property) {
        Object propertyValue = accessor.getProperty((PersistentProperty)property);
        Class propertyType = property.getType();
        ValueBinder valueBinder = sink.set(property.getColumnName());
        boolean valueSet = false;
        if (ConversionUtils.isIterableNonByteArrayType(propertyType)) {
            valueSet = this.attemptSetIterableValue((Iterable)propertyValue, (ValueBinder<Mutation.WriteBuilder>)valueBinder, property);
        } else if (property.isCommitTimestamp()) {
            valueSet = this.attemptSetSingleItemValue(Value.COMMIT_TIMESTAMP, Timestamp.class, (ValueBinder<Mutation.WriteBuilder>)valueBinder, Timestamp.class);
        } else if (property.getAnnotatedColumnItemType() != null) {
            valueSet = this.attemptSetSingleItemValue(propertyValue, propertyType, (ValueBinder<Mutation.WriteBuilder>)valueBinder, SpannerTypeMapper.getSimpleJavaClassFor(property.getAnnotatedColumnItemType()));
        } else {
            if (!valueSet) {
                valueSet = this.attemptSetSingleItemValue(propertyValue, propertyType, (ValueBinder<Mutation.WriteBuilder>)valueBinder, propertyType);
            }
            if (!valueSet) {
                Class<?> targetType;
                Iterator<Class<?>> iterator = singleItemTypeValueBinderMethodMap.keySet().iterator();
                while (iterator.hasNext() && !(valueSet = this.attemptSetSingleItemValue(propertyValue, propertyType, (ValueBinder<Mutation.WriteBuilder>)valueBinder, targetType = iterator.next()))) {
                }
            }
        }
        if (!valueSet) {
            throw new SpannerDataException(String.format("Unsupported mapping for type: %s", propertyValue.getClass()));
        }
    }

    private boolean attemptSetIterableValue(Iterable<Object> value, ValueBinder<Mutation.WriteBuilder> valueBinder, SpannerPersistentProperty spannerPersistentProperty) {
        boolean valueSet;
        block4: {
            Class<?> targetType;
            Class innerType;
            block3: {
                innerType = ConversionUtils.boxIfNeeded(spannerPersistentProperty.getColumnInnerType());
                if (innerType == null) {
                    return false;
                }
                valueSet = false;
                if (spannerPersistentProperty.getAnnotatedColumnItemType() == null) break block3;
                valueSet = this.attemptSetIterablePropertyWithType(value, valueBinder, innerType, SpannerTypeMapper.getSimpleJavaClassFor(spannerPersistentProperty.getAnnotatedColumnItemType()));
                break block4;
            }
            if (!valueSet && iterablePropertyType2ToMethodMap.containsKey(innerType)) {
                iterablePropertyType2ToMethodMap.get(innerType).accept(valueBinder, value);
                valueSet = true;
            }
            if (valueSet) break block4;
            Iterator<Class<?>> iterator = iterablePropertyType2ToMethodMap.keySet().iterator();
            while (iterator.hasNext() && !(valueSet = this.attemptSetIterablePropertyWithType(value, valueBinder, innerType, targetType = iterator.next()))) {
            }
        }
        return valueSet;
    }

    private boolean attemptSetIterablePropertyWithType(Iterable<Object> value, ValueBinder<Mutation.WriteBuilder> valueBinder, Class innerType, Class<?> targetType) {
        if (this.writeConverter.canConvert(innerType, targetType)) {
            BiConsumer<ValueBinder<?>, Iterable> toMethod = iterablePropertyType2ToMethodMap.get(targetType);
            toMethod.accept(valueBinder, value != null ? ConversionUtils.convertIterable(value, targetType, this.writeConverter) : null);
            return true;
        }
        return false;
    }

    private <T> boolean attemptSetSingleItemValue(Object value, Class<?> sourceType, ValueBinder<Mutation.WriteBuilder> valueBinder, Class<T> targetType) {
        if (!this.writeConverter.canConvert(sourceType, targetType)) {
            return false;
        }
        Class innerType = ConversionUtils.boxIfNeeded(targetType);
        BiFunction<ValueBinder, ?, ?> toMethod = singleItemTypeValueBinderMethodMap.get(innerType);
        if (toMethod == null) {
            return false;
        }
        Object ignored = toMethod.apply(valueBinder, value != null ? (Object)this.writeConverter.convert(value, targetType) : null);
        return true;
    }

    static {
        iterablePropertyType2ToMethodMap = ConverterAwareMappingSpannerEntityWriter.createIterableTypeMapping();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put(Date.class, ValueBinder::to);
        builder.put(Boolean.class, ValueBinder::to);
        builder.put(Long.class, ValueBinder::to);
        builder.put(Long.TYPE, ValueBinder::to);
        builder.put(Double.class, ValueBinder::to);
        builder.put(Double.TYPE, ValueBinder::to);
        builder.put(String.class, ValueBinder::to);
        builder.put(Timestamp.class, ValueBinder::to);
        builder.put(ByteArray.class, ValueBinder::to);
        builder.put(double[].class, ValueBinder::toFloat64Array);
        builder.put(boolean[].class, ValueBinder::toBoolArray);
        builder.put(long[].class, ValueBinder::toInt64Array);
        builder.put(Struct.class, ValueBinder::to);
        singleItemTypeValueBinderMethodMap = builder.build();
    }
}

