/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.mapping;

import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.BeansException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntityImpl;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentPropertyImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;

public class SpannerMappingContext
extends AbstractMappingContext<SpannerPersistentEntity<?>, SpannerPersistentProperty>
implements ApplicationContextAware {
    private static final FieldNamingStrategy DEFAULT_NAMING_STRATEGY = PropertyNameFieldNamingStrategy.INSTANCE;
    private FieldNamingStrategy fieldNamingStrategy = DEFAULT_NAMING_STRATEGY;
    private ApplicationContext applicationContext;

    public void setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy != null ? fieldNamingStrategy : DEFAULT_NAMING_STRATEGY;
    }

    public FieldNamingStrategy getFieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    protected <T> SpannerPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        SpannerPersistentEntityImpl<T> persistentEntity = this.constructPersistentEntity(typeInformation);
        if (this.applicationContext != null) {
            persistentEntity.setApplicationContext(this.applicationContext);
        }
        return persistentEntity;
    }

    @VisibleForTesting
    protected <T> SpannerPersistentEntityImpl<T> constructPersistentEntity(TypeInformation<T> typeInformation) {
        return new SpannerPersistentEntityImpl<T>(typeInformation);
    }

    protected SpannerPersistentProperty createPersistentProperty(Property property, SpannerPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new SpannerPersistentPropertyImpl(property, (PersistentEntity<?, SpannerPersistentProperty>)owner, simpleTypeHolder, this.fieldNamingStrategy);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

