/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.admin;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalLong;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import org.springframework.cloud.gcp.data.spanner.core.convert.ConversionUtils;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerEntityProcessor;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerTypeMapper;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.util.Assert;

public class SpannerSchemaUtils {
    private final SpannerMappingContext mappingContext;
    private final SpannerEntityProcessor spannerEntityProcessor;
    private final boolean createInterleavedTableDdlOnDeleteCascade;

    public SpannerSchemaUtils(SpannerMappingContext mappingContext, SpannerEntityProcessor spannerEntityProcessor, boolean createInterleavedTableDdlOnDeleteCascade) {
        Assert.notNull((Object)((Object)mappingContext), (String)"A valid mapping context for Cloud Spanner is required.");
        Assert.notNull((Object)spannerEntityProcessor, (String)"A valid results mapper for Cloud Spanner is required.");
        this.mappingContext = mappingContext;
        this.spannerEntityProcessor = spannerEntityProcessor;
        this.createInterleavedTableDdlOnDeleteCascade = createInterleavedTableDdlOnDeleteCascade;
    }

    public String getDropTableDdlString(Class entityClass) {
        return "DROP TABLE " + ((SpannerPersistentEntity)this.mappingContext.getPersistentEntity(entityClass)).tableName();
    }

    public Key getKey(Object object) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(object.getClass());
        return (Key)persistentEntity.getPropertyAccessor(object).getProperty((PersistentProperty)persistentEntity.getIdProperty());
    }

    public <T> String getCreateTableDdlString(Class<T> entityClass) {
        SpannerPersistentEntity spannerPersistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        StringBuilder stringBuilder = new StringBuilder("CREATE TABLE " + spannerPersistentEntity.tableName() + " ( ");
        StringJoiner columnStrings = new StringJoiner(" , ");
        this.addColumnDdlStrings(spannerPersistentEntity, columnStrings);
        stringBuilder.append(columnStrings.toString()).append(" ) PRIMARY KEY ( ");
        StringJoiner keyStrings = new StringJoiner(" , ");
        this.addPrimaryKeyColumnNames(spannerPersistentEntity, keyStrings);
        stringBuilder.append(keyStrings.toString()).append(" )");
        return stringBuilder.toString();
    }

    public List<String> getCreateTableDdlStringsForInterleavedHierarchy(Class entityClass) {
        ArrayList<String> ddlStrings = new ArrayList<String>();
        this.getCreateTableDdlStringsForInterleavedHierarchy(null, entityClass, ddlStrings, new HashSet<Class>());
        return ddlStrings;
    }

    public List<String> getDropTableDdlStringsForInterleavedHierarchy(Class entityClass) {
        ArrayList<String> ddlStrings = new ArrayList<String>();
        this.getDropTableDdlStringsForInterleavedHierarchy(entityClass, ddlStrings, new HashSet<Class>());
        return ddlStrings;
    }

    String getColumnDdlString(SpannerPersistentProperty spannerPersistentProperty, SpannerEntityProcessor spannerEntityProcessor) {
        Class columnType = spannerPersistentProperty.getType();
        String columnName = spannerPersistentProperty.getColumnName() + " ";
        Type.Code spannerColumnType = spannerPersistentProperty.getAnnotatedColumnItemType();
        if (ConversionUtils.isIterableNonByteArrayType(columnType)) {
            Class<?> innerType = spannerPersistentProperty.getColumnInnerType();
            Class<?> spannerJavaType = spannerEntityProcessor.getCorrespondingSpannerJavaType(innerType, true);
            if (spannerColumnType == null) {
                spannerColumnType = SpannerTypeMapper.getSimpleTypeCodeForJavaType(spannerJavaType);
            }
            if (spannerColumnType == null) {
                throw new SpannerDataException("Could not find suitable Cloud Spanner column inner type for property type: " + innerType);
            }
            return columnName + this.getTypeDdlString(spannerColumnType, true, spannerPersistentProperty.getMaxColumnLength(), spannerPersistentProperty.isGenerateSchemaNotNull(), spannerPersistentProperty.isCommitTimestamp());
        }
        Class<?> spannerJavaType = spannerEntityProcessor.getCorrespondingSpannerJavaType(columnType, false);
        if (spannerJavaType == null) {
            throw new SpannerDataException("The currently configured custom type converters cannot convert the given type to a Cloud Spanner-compatible column type: " + columnType);
        }
        if (spannerColumnType == null) {
            Type.Code code = spannerColumnType = spannerJavaType.isArray() ? SpannerTypeMapper.getArrayTypeCodeForJavaType(spannerJavaType) : SpannerTypeMapper.getSimpleTypeCodeForJavaType(spannerJavaType);
        }
        if (spannerColumnType == null) {
            throw new SpannerDataException("Could not find suitable Cloud Spanner column type for property type :" + columnType);
        }
        return columnName + this.getTypeDdlString(spannerColumnType, spannerJavaType.isArray(), spannerPersistentProperty.getMaxColumnLength(), spannerPersistentProperty.isGenerateSchemaNotNull(), spannerPersistentProperty.isCommitTimestamp());
    }

    private <T> void addPrimaryKeyColumnNames(SpannerPersistentEntity<T> spannerPersistentEntity, StringJoiner keyStrings) {
        for (SpannerPersistentProperty keyProp : spannerPersistentEntity.getPrimaryKeyProperties()) {
            if (keyProp.isEmbedded()) {
                this.addPrimaryKeyColumnNames((SpannerPersistentEntity)this.mappingContext.getPersistentEntity(keyProp.getType()), keyStrings);
                continue;
            }
            keyStrings.add(keyProp.getColumnName());
        }
    }

    private <T> void addColumnDdlStrings(SpannerPersistentEntity<T> spannerPersistentEntity, StringJoiner stringJoiner) {
        spannerPersistentEntity.doWithColumnBackedProperties((PropertyHandler<SpannerPersistentProperty>)((PropertyHandler)spannerPersistentProperty -> {
            if (spannerPersistentProperty.isEmbedded()) {
                this.addColumnDdlStrings((SpannerPersistentEntity)this.mappingContext.getPersistentEntity(spannerPersistentProperty.getType()), stringJoiner);
            } else {
                stringJoiner.add(this.getColumnDdlString((SpannerPersistentProperty)spannerPersistentProperty, this.spannerEntityProcessor));
            }
        }));
    }

    private void getCreateTableDdlStringsForInterleavedHierarchy(String parentTable, Class entityClass, List<String> ddlStrings, Set<Class> seenClasses) {
        this.getDdlStringForInterleavedHierarchy(parentTable, entityClass, ddlStrings, seenClasses, (type, parent) -> this.getCreateTableDdlString((Class)type) + (parent != null ? ", INTERLEAVE IN PARENT " + parent + " ON DELETE " + (this.createInterleavedTableDdlOnDeleteCascade ? "CASCADE" : "NO ACTION") : ""), false);
    }

    private void getDropTableDdlStringsForInterleavedHierarchy(Class entityClass, List<String> dropStrings, Set<Class> seenClasses) {
        this.getDdlStringForInterleavedHierarchy(null, entityClass, dropStrings, seenClasses, (type, unused) -> this.getDropTableDdlString((Class)type), true);
    }

    private void getDdlStringForInterleavedHierarchy(String parentTable, Class entityClass, List<String> ddlStrings, Set<Class> seenClasses, BiFunction<Class, String, String> generateSingleDdlStringFunc, boolean prependDdlString) {
        if (seenClasses.contains(entityClass)) {
            return;
        }
        seenClasses.add(entityClass);
        ddlStrings.add(prependDdlString ? 0 : ddlStrings.size(), generateSingleDdlStringFunc.apply(entityClass, parentTable));
        SpannerPersistentEntity spannerPersistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        spannerPersistentEntity.doWithInterleavedProperties((PropertyHandler<SpannerPersistentProperty>)((PropertyHandler)spannerPersistentProperty -> this.getDdlStringForInterleavedHierarchy(spannerPersistentEntity.tableName(), spannerPersistentProperty.getColumnInnerType(), ddlStrings, seenClasses, generateSingleDdlStringFunc, prependDdlString)));
    }

    private String getTypeDdlString(Type.Code type, boolean isArray, OptionalLong dataLength, boolean isNotNull, boolean isCommitTimestamp) {
        return (isCommitTimestamp ? Type.Code.TIMESTAMP.toString() : this.getTypeDdlStringWithLength(type, isArray, dataLength)) + (isNotNull ? " NOT NULL" : "") + (isCommitTimestamp ? " OPTIONS (allow_commit_timestamp=true)" : "");
    }

    private String getTypeDdlStringWithLength(Type.Code type, boolean isArray, OptionalLong dataLength) {
        Assert.notNull((Object)type, (String)"A valid Spanner column type is required.");
        if (isArray) {
            return "ARRAY<" + this.getTypeDdlStringWithLength(type, false, dataLength) + ">";
        }
        return type.toString() + (type == Type.Code.STRING || type == Type.Code.BYTES ? "(" + (dataLength.isPresent() ? Long.valueOf(dataLength.getAsLong()) : "MAX") + ")" : "");
    }
}

