/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.cloudfoundry;

import com.google.api.client.util.ArrayMap;
import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfEnv;
import io.pivotal.cfenv.core.CfService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.gcp.core.util.MapBuilder;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class GcpCloudFoundryEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Log LOGGER = LogFactory.getLog(GcpCloudFoundryEnvironmentPostProcessor.class);
    private static final String SPRING_CLOUD_GCP_PROPERTY_PREFIX = "spring.cloud.gcp.";
    private int order = -2147483639;
    private static Map<String, String> sqlPropertyMap = new ArrayMap();

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        CfEnv cfEnv = new CfEnv();
        if (cfEnv.isInCf()) {
            Properties gcpCfServiceProperties = new Properties();
            HashSet<GcpCfService> servicesToMap = new HashSet<GcpCfService>(Arrays.asList(GcpCfService.values()));
            List sqlServices = cfEnv.findServicesByLabel(new String[]{GcpCfService.MYSQL.getCfServiceName(), GcpCfService.POSTGRES.getCfServiceName()});
            if (sqlServices.size() == 2) {
                LOGGER.warn((Object)"Both MySQL and PostgreSQL bound to the app. Not configuring Cloud SQL.");
                servicesToMap.remove((Object)GcpCfService.MYSQL);
                servicesToMap.remove((Object)GcpCfService.POSTGRES);
            }
            servicesToMap.forEach(service -> gcpCfServiceProperties.putAll((Map<?, ?>)GcpCloudFoundryEnvironmentPostProcessor.retrieveCfProperties(cfEnv, service.getGcpServiceName(), service.getCfServiceName(), service.getCfPropNameToGcp())));
            if (gcpCfServiceProperties.containsKey("spring.cloud.gcp.sql.instance-name")) {
                String instanceConnectionName = gcpCfServiceProperties.getProperty("spring.cloud.gcp.sql.project-id") + ":" + gcpCfServiceProperties.getProperty("spring.cloud.gcp.sql.region") + ":" + gcpCfServiceProperties.getProperty("spring.cloud.gcp.sql.instance-name");
                gcpCfServiceProperties.put("spring.cloud.gcp.sql.instance-connection-name", instanceConnectionName);
            }
            if (gcpCfServiceProperties.containsKey("spring.cloud.gcp.sql.username")) {
                gcpCfServiceProperties.put("spring.datasource.username", gcpCfServiceProperties.getProperty("spring.cloud.gcp.sql.username"));
            }
            if (gcpCfServiceProperties.containsKey("spring.cloud.gcp.sql.password")) {
                gcpCfServiceProperties.put("spring.datasource.password", gcpCfServiceProperties.getProperty("spring.cloud.gcp.sql.password"));
            }
            environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("gcpCf", gcpCfServiceProperties));
        }
    }

    private static Properties retrieveCfProperties(CfEnv cfEnv, String gcpServiceName, String cfServiceName, Map<String, String> fieldsToMap) {
        Properties properties = new Properties();
        try {
            List serviceBindings = cfEnv.findServicesByLabel(new String[]{cfServiceName});
            if (serviceBindings == null) {
                return properties;
            }
            if (serviceBindings.size() != 1) {
                LOGGER.warn((Object)("The service " + cfServiceName + " has to be bound to a Cloud Foundry application once and only once."));
                return properties;
            }
            CfService cfService = (CfService)serviceBindings.get(0);
            CfCredentials credentials = cfService.getCredentials();
            String prefix = SPRING_CLOUD_GCP_PROPERTY_PREFIX + gcpServiceName + ".";
            fieldsToMap.forEach((cfPropKey, gcpPropKey) -> properties.put(prefix + gcpPropKey, credentials.getMap().get(cfPropKey)));
        }
        catch (ClassCastException ex) {
            LOGGER.warn((Object)"Unexpected format of CF (VCAP) properties", (Throwable)ex);
        }
        return properties;
    }

    public int getOrder() {
        return this.order;
    }

    static /* synthetic */ Map access$000() {
        return sqlPropertyMap;
    }

    static {
        sqlPropertyMap.put("ProjectId", "project-id");
        sqlPropertyMap.put("PrivateKeyData", "credentials.encoded-key");
        sqlPropertyMap.put("database_name", "database-name");
        sqlPropertyMap.put("region", "region");
        sqlPropertyMap.put("instance_name", "instance-name");
        sqlPropertyMap.put("Username", "username");
        sqlPropertyMap.put("Password", "password");
    }

    private static enum GcpCfService {
        PUBSUB("google-pubsub", "pubsub", new MapBuilder().put((Object)"ProjectId", (Object)"project-id").put((Object)"PrivateKeyData", (Object)"credentials.encoded-key").build()),
        STORAGE("google-storage", "storage", new MapBuilder().put((Object)"ProjectId", (Object)"project-id").put((Object)"PrivateKeyData", (Object)"credentials.encoded-key").build()),
        SPANNER("google-spanner", "spanner", new MapBuilder().put((Object)"ProjectId", (Object)"project-id").put((Object)"PrivateKeyData", (Object)"credentials.encoded-key").put((Object)"instance_id", (Object)"instance-id").build()),
        DATASTORE("google-datastore", "datastore", new MapBuilder().put((Object)"ProjectId", (Object)"project-id").put((Object)"PrivateKeyData", (Object)"credentials.encoded-key").build()),
        FIRESTORE("google-firestore", "firestore", new MapBuilder().put((Object)"ProjectId", (Object)"project-id").put((Object)"PrivateKeyData", (Object)"credentials.encoded-key").build()),
        TRACE("google-stackdriver-trace", "trace", new MapBuilder().put((Object)"ProjectId", (Object)"project-id").put((Object)"PrivateKeyData", (Object)"credentials.encoded-key").build()),
        BIGQUERY("google-bigquery", "bigquery", new MapBuilder().put((Object)"ProjectId", (Object)"project-id").put((Object)"PrivateKeyData", (Object)"credentials.encoded-key").put((Object)"dataset_id", (Object)"dataset-name").build()),
        MYSQL("google-cloudsql-mysql", "sql", GcpCloudFoundryEnvironmentPostProcessor.access$000()),
        POSTGRES("google-cloudsql-postgres", "sql", GcpCloudFoundryEnvironmentPostProcessor.access$000());

        private String cfServiceName;
        private String gcpServiceName;
        private Map<String, String> cfPropNameToGcp;

        private GcpCfService(String cfServiceName, String gcpServiceName, Map<String, String> cfPropNameToGcp) {
            this.cfServiceName = cfServiceName;
            this.gcpServiceName = gcpServiceName;
            this.cfPropNameToGcp = cfPropNameToGcp;
        }

        public String getCfServiceName() {
            return this.cfServiceName;
        }

        public Map<String, String> getCfPropNameToGcp() {
            return this.cfPropNameToGcp;
        }

        public String getGcpServiceName() {
            return this.gcpServiceName;
        }
    }
}

