/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.metrics;

import com.google.api.gax.core.CredentialsProvider;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.stackdriver.StackdriverConfig;
import java.io.IOException;
import org.springframework.boot.actuate.autoconfigure.metrics.export.stackdriver.StackdriverMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.stackdriver.StackdriverProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.metrics.GcpMetricsProperties;
import org.springframework.cloud.gcp.autoconfigure.metrics.GcpStackdriverPropertiesConfigAdapter;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={StackdriverMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={StepMeterRegistry.class, StackdriverConfig.class})
@ConditionalOnBean(value={Clock.class})
@EnableConfigurationProperties(value={GcpMetricsProperties.class, StackdriverProperties.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.metrics.enabled"}, matchIfMissing=true, havingValue="true")
public class GcpStackdriverMetricsAutoConfiguration {
    private final StackdriverProperties stackdriverProperties;
    private final String projectId;
    private final CredentialsProvider credentialsProvider;

    public GcpStackdriverMetricsAutoConfiguration(GcpMetricsProperties gcpMetricsProperties, StackdriverProperties stackdriverProperties, GcpProjectIdProvider gcpProjectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this.stackdriverProperties = stackdriverProperties;
        this.projectId = gcpMetricsProperties.getProjectId() != null ? gcpMetricsProperties.getProjectId() : gcpProjectIdProvider.getProjectId();
        this.credentialsProvider = gcpMetricsProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpMetricsProperties) : credentialsProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public StackdriverConfig stackdriverConfig() {
        return new GcpStackdriverPropertiesConfigAdapter(this.stackdriverProperties, this.projectId, this.credentialsProvider);
    }
}

