/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.secretmanager;

import com.google.cloud.secretmanager.v1beta1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1beta1.ProjectName;
import com.google.cloud.secretmanager.v1beta1.Secret;
import com.google.cloud.secretmanager.v1beta1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1beta1.SecretVersionName;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.core.env.EnumerablePropertySource;

public class SecretManagerPropertySource
extends EnumerablePropertySource<SecretManagerServiceClient> {
    private static final String LATEST_VERSION_STRING = "latest";
    private final Map<String, Object> properties;
    private final String[] propertyNames;

    public SecretManagerPropertySource(String propertySourceName, SecretManagerServiceClient client, GcpProjectIdProvider projectIdProvider, String secretsPrefix) {
        super(propertySourceName, (Object)client);
        Map<String, Object> propertiesMap = SecretManagerPropertySource.createSecretsPropertiesMap(client, projectIdProvider.getProjectId(), secretsPrefix);
        this.properties = propertiesMap;
        this.propertyNames = propertiesMap.keySet().toArray(new String[propertiesMap.size()]);
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private static Map<String, Object> createSecretsPropertiesMap(SecretManagerServiceClient client, String projectId, String secretsPrefix) {
        SecretManagerServiceClient.ListSecretsPagedResponse response = client.listSecrets(ProjectName.of((String)projectId));
        HashMap<String, Object> secretsMap = new HashMap<String, Object>();
        for (Secret secret : response.iterateAll()) {
            String secretId = SecretManagerPropertySource.extractSecretId(secret);
            ByteString secretPayload = SecretManagerPropertySource.getSecretPayload(client, projectId, secretId);
            secretsMap.put(secretsPrefix + secretId, secretPayload);
        }
        return secretsMap;
    }

    private static ByteString getSecretPayload(SecretManagerServiceClient client, String projectId, String secretId) {
        SecretVersionName secretVersionName = SecretVersionName.newBuilder().setProject(projectId).setSecret(secretId).setSecretVersion(LATEST_VERSION_STRING).build();
        AccessSecretVersionResponse response = client.accessSecretVersion(secretVersionName);
        return response.getPayload().getData();
    }

    private static String extractSecretId(Secret secret) {
        String[] secretNameTokens = secret.getName().split("/");
        return secretNameTokens[secretNameTokens.length - 1];
    }
}

