/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.secretmanager;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.secretmanager.v1beta1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1beta1.SecretManagerServiceSettings;
import java.io.IOException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.secretmanager.GcpSecretManagerProperties;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.DefaultGcpProjectIdProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.core.UserAgentHeaderProvider;
import org.springframework.cloud.gcp.secretmanager.SecretManagerTemplate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={GcpSecretManagerProperties.class})
@ConditionalOnClass(value={SecretManagerServiceClient.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.secretmanager.enabled"}, matchIfMissing=true)
public class GcpSecretManagerAutoConfiguration {
    private final GcpSecretManagerProperties properties;
    private final CredentialsProvider credentialsProvider;
    private final GcpProjectIdProvider gcpProjectIdProvider;

    public GcpSecretManagerAutoConfiguration(GcpSecretManagerProperties properties) throws IOException {
        this.properties = properties;
        this.credentialsProvider = new DefaultCredentialsProvider((CredentialsSupplier)properties);
        this.gcpProjectIdProvider = properties.getProjectId() != null ? properties::getProjectId : new DefaultGcpProjectIdProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretManagerServiceClient secretManagerClient() throws IOException {
        SecretManagerServiceSettings settings = ((SecretManagerServiceSettings.Builder)((SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpSecretManagerAutoConfiguration.class))).build();
        return SecretManagerServiceClient.create((SecretManagerServiceSettings)settings);
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretManagerTemplate secretManagerTemplate(SecretManagerServiceClient client) {
        return new SecretManagerTemplate(client, this.gcpProjectIdProvider);
    }
}

