/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config.conditional;

import org.springframework.cloud.gateway.config.conditional.ConditionalOnEnabledFilter;
import org.springframework.cloud.gateway.config.conditional.OnEnabledComponent;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerFilterFactory;
import org.springframework.cloud.gateway.support.NameUtils;

public class OnEnabledFilter
extends OnEnabledComponent<GatewayFilterFactory<?>> {
    @Override
    protected String normalizeComponentName(Class<? extends GatewayFilterFactory<?>> filterClass) {
        if (SpringCloudCircuitBreakerFilterFactory.class.isAssignableFrom(filterClass)) {
            return "filter." + NameUtils.normalizeToCanonicalPropertyFormat("CircuitBreaker");
        }
        return "filter." + NameUtils.normalizeFilterFactoryNameAsProperty(filterClass);
    }

    @Override
    protected Class<?> annotationClass() {
        return ConditionalOnEnabledFilter.class;
    }

    @Override
    protected Class<? extends GatewayFilterFactory<?>> defaultValueClass() {
        return DefaultValue.class;
    }

    static class DefaultValue
    implements GatewayFilterFactory<Object> {
        DefaultValue() {
        }

        @Override
        public GatewayFilter apply(Object config) {
            throw new UnsupportedOperationException("class DefaultValue is never meant to be intantiated");
        }
    }
}

