/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.filter.RetryFilterFunctions;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.policy.CompositeRetryPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.retry.support.RetryTemplateBuilder;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

@Deprecated
public abstract class GatewayRetryFilterFunctions {
    private GatewayRetryFilterFunctions() {
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> retry(int retries) {
        return GatewayRetryFilterFunctions.retry((RetryFilterFunctions.RetryConfig config) -> config.setRetries(retries));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> retry(Consumer<RetryFilterFunctions.RetryConfig> configConsumer) {
        RetryFilterFunctions.RetryConfig config = new RetryFilterFunctions.RetryConfig();
        configConsumer.accept(config);
        return GatewayRetryFilterFunctions.retry(config);
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> retry(RetryFilterFunctions.RetryConfig config) {
        RetryTemplateBuilder retryTemplateBuilder = RetryTemplate.builder();
        CompositeRetryPolicy compositeRetryPolicy = new CompositeRetryPolicy();
        HashMap retryableExceptions = new HashMap();
        config.getExceptions().forEach(exception -> retryableExceptions.put(exception, true));
        SimpleRetryPolicy simpleRetryPolicy = new SimpleRetryPolicy(config.getRetries(), retryableExceptions);
        compositeRetryPolicy.setPolicies(Arrays.asList(new RetryPolicy[]{simpleRetryPolicy, new HttpRetryPolicy(config)}).toArray(new RetryPolicy[0]));
        RetryTemplate retryTemplate = retryTemplateBuilder.customPolicy((RetryPolicy)compositeRetryPolicy).build();
        return (request, next) -> (ServerResponse)retryTemplate.execute(context -> {
            if (config.isCacheBody()) {
                MvcUtils.getOrCacheBody(request);
            }
            GatewayRetryFilterFunctions.reset(request);
            ServerResponse serverResponse = next.handle(request);
            if (GatewayRetryFilterFunctions.isRetryableStatusCode(serverResponse.statusCode(), config) && GatewayRetryFilterFunctions.isRetryableMethod(request.method(), config)) {
                throw new RetryFilterFunctions.RetryException(request, serverResponse);
            }
            return serverResponse;
        });
    }

    private static void reset(ServerRequest request) throws IOException {
        ClientHttpResponse clientHttpResponse = (ClientHttpResponse)MvcUtils.getAttribute(request, MvcUtils.CLIENT_RESPONSE_ATTR);
        if (clientHttpResponse != null) {
            clientHttpResponse.close();
            MvcUtils.putAttribute(request, MvcUtils.CLIENT_RESPONSE_ATTR, null);
        }
    }

    private static boolean isRetryableStatusCode(HttpStatusCode httpStatus, RetryFilterFunctions.RetryConfig config) {
        return config.getSeries().stream().anyMatch(series -> HttpStatus.Series.resolve((int)httpStatus.value()) == series);
    }

    private static boolean isRetryableMethod(HttpMethod method, RetryFilterFunctions.RetryConfig config) {
        return config.getMethods().contains(method);
    }

    public static class HttpRetryPolicy
    extends NeverRetryPolicy {
        private final RetryFilterFunctions.RetryConfig config;

        public HttpRetryPolicy(RetryFilterFunctions.RetryConfig config) {
            this.config = config;
        }

        public boolean canRetry(RetryContext context) {
            Throwable throwable = context.getLastThrowable();
            if (throwable instanceof RetryFilterFunctions.RetryException) {
                RetryFilterFunctions.RetryException e = (RetryFilterFunctions.RetryException)((Object)throwable);
                return GatewayRetryFilterFunctions.isRetryableStatusCode(e.getResponse().statusCode(), this.config) && GatewayRetryFilterFunctions.isRetryableMethod(e.getRequest().method(), this.config);
            }
            return super.canRetry(context);
        }
    }
}

