/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.invoke.convert;

import java.util.Objects;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationParameter;
import org.springframework.cloud.gateway.server.mvc.invoke.ParameterMappingException;
import org.springframework.cloud.gateway.server.mvc.invoke.ParameterValueMapper;
import org.springframework.core.convert.ConversionService;

public class ConversionServiceParameterValueMapper
implements ParameterValueMapper {
    private final ConversionService conversionService;

    public ConversionServiceParameterValueMapper() {
        this(ApplicationConversionService.getSharedInstance());
    }

    public ConversionServiceParameterValueMapper(ConversionService conversionService) {
        Objects.requireNonNull(conversionService, "ConversionService must not be null");
        this.conversionService = conversionService;
    }

    @Override
    public Object mapParameterValue(OperationParameter parameter, Object value) throws ParameterMappingException {
        try {
            Object toReturn = this.conversionService.convert(value, parameter.getType());
            Objects.requireNonNull(toReturn, "ConversionService returned null");
            return toReturn;
        }
        catch (Exception ex) {
            throw new ParameterMappingException(parameter, value, ex);
        }
    }
}

