/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public interface ProxyExchange {
    default public RequestBuilder request(ServerRequest serverRequest) {
        return new DefaultRequestBuilder(serverRequest);
    }

    public ServerResponse exchange(Request var1);

    public static class DefaultRequestBuilder
    implements RequestBuilder,
    Request {
        final ServerRequest serverRequest;
        private HttpHeaders httpHeaders;
        private HttpMethod method;
        private @Nullable URI uri;
        private ArrayList<ResponseConsumer> responseConsumers = new ArrayList();

        DefaultRequestBuilder(ServerRequest serverRequest) {
            this.serverRequest = serverRequest;
            this.method = serverRequest.method();
            this.httpHeaders = serverRequest.headers().asHttpHeaders();
        }

        @Override
        public RequestBuilder headers(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this;
        }

        @Override
        public RequestBuilder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @Override
        public RequestBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public RequestBuilder responseConsumer(ResponseConsumer responseConsumer) {
            this.responseConsumers.add(responseConsumer);
            return this;
        }

        @Override
        public Request build() {
            return this;
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        @Override
        public HttpMethod getMethod() {
            return this.method;
        }

        @Override
        public @Nullable URI getUri() {
            return this.uri;
        }

        @Override
        public ServerRequest getServerRequest() {
            return this.serverRequest;
        }

        @Override
        public Collection<ResponseConsumer> getResponseConsumers() {
            return this.responseConsumers;
        }
    }

    public static interface RequestBuilder {
        public RequestBuilder headers(HttpHeaders var1);

        public RequestBuilder method(HttpMethod var1);

        public RequestBuilder uri(URI var1);

        public RequestBuilder responseConsumer(ResponseConsumer var1);

        public Request build();
    }

    public static interface ResponseConsumer
    extends BiConsumer<Response, ServerResponse> {
    }

    public static interface Response
    extends HttpMessage {
        public HttpStatusCode getStatusCode();
    }

    public static interface Request
    extends HttpMessage {
        public HttpMethod getMethod();

        public @Nullable URI getUri();

        public ServerRequest getServerRequest();

        public Collection<ResponseConsumer> getResponseConsumers();
    }
}

