/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.springframework.cloud.gateway.server.mvc.common.HttpStatusHolder;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.filter.BodyFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.RewriteLocationResponseHeaderFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayServerResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public abstract class AfterFilterFunctions {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private AfterFilterFunctions() {
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> addResponseHeader(String name, String ... values) {
        return (request, response) -> {
            String[] expandedValues = MvcUtils.expandMultiple(request, values);
            response.headers().addAll(name, Arrays.asList(expandedValues));
            return response;
        };
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> dedupeResponseHeader(String name) {
        return AfterFilterFunctions.dedupeResponseHeader(name, DedupeStrategy.RETAIN_FIRST);
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> dedupeResponseHeader(String name, DedupeStrategy strategy) {
        Assert.hasText((String)name, (String)"name must not be null or empty");
        Assert.notNull((Object)((Object)strategy), (String)"strategy must not be null");
        return (request, response) -> {
            AfterFilterFunctions.dedupeHeaders(response.headers(), name, strategy);
            return response;
        };
    }

    private static void dedupeHeaders(HttpHeaders headers, String names, DedupeStrategy strategy) {
        String[] tokens;
        if (headers == null || names == null || strategy == null) {
            return;
        }
        for (String name : tokens = StringUtils.tokenizeToStringArray((String)names, (String)" ", (boolean)true, (boolean)true)) {
            AfterFilterFunctions.dedupeHeader(headers, name.trim(), strategy);
        }
    }

    private static void dedupeHeader(HttpHeaders headers, String name, DedupeStrategy strategy) {
        List values = headers.get(name);
        if (values == null || values.size() <= 1) {
            return;
        }
        switch (strategy.ordinal()) {
            case 0: {
                headers.set(name, (String)values.get(0));
                break;
            }
            case 1: {
                headers.set(name, (String)values.get(values.size() - 1));
                break;
            }
            case 2: {
                headers.put(name, new ArrayList(new LinkedHashSet(values)));
                break;
            }
        }
    }

    public static <T, R> BiFunction<ServerRequest, ServerResponse, ServerResponse> modifyResponseBody(Class<T> inClass, Class<R> outClass, String newContentType, BodyFilterFunctions.RewriteResponseFunction<T, R> rewriteFunction) {
        return BodyFilterFunctions.modifyResponseBody(inClass, outClass, newContentType, rewriteFunction);
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> removeResponseHeader(String name) {
        return (request, response) -> {
            response.headers().remove(name);
            return response;
        };
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> rewriteLocationResponseHeader() {
        return RewriteLocationResponseHeaderFilterFunctions.rewriteLocationResponseHeader(config -> {});
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> rewriteLocationResponseHeader(Consumer<RewriteLocationResponseHeaderFilterFunctions.RewriteLocationResponseHeaderConfig> configConsumer) {
        return RewriteLocationResponseHeaderFilterFunctions.rewriteLocationResponseHeader(configConsumer);
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> rewriteResponseHeader(String name, String regexp, String originalReplacement) {
        String replacement = originalReplacement.replace("$\\", "$");
        Pattern pattern = Pattern.compile(regexp);
        return (request, response) -> {
            BiFunction<String, List, List> remappingFunction = (key, values) -> {
                List<String> rewrittenValues = values.stream().map(value -> pattern.matcher((CharSequence)value).replaceAll(replacement)).toList();
                return new ArrayList<String>(rewrittenValues);
            };
            if (response.headers().get(name) != null) {
                List oldValue = response.headers().get(name);
                List newValue = remappingFunction.apply(name, oldValue);
                if (newValue != null) {
                    response.headers().put(name, newValue);
                } else {
                    response.headers().remove(name);
                }
            }
            return response;
        };
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> setResponseHeader(String name, String value) {
        return (request, response) -> {
            String expandedValue = MvcUtils.expand(request, value);
            response.headers().set(name, expandedValue);
            return response;
        };
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> setStatus(int statusCode) {
        return AfterFilterFunctions.setStatus(new HttpStatusHolder(null, statusCode));
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> setStatus(String statusCode) {
        return AfterFilterFunctions.setStatus(HttpStatusHolder.valueOf(statusCode));
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> setStatus(HttpStatusCode statusCode) {
        return AfterFilterFunctions.setStatus(new HttpStatusHolder(statusCode, null));
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> setStatus(HttpStatusHolder statusCode) {
        return (request, response) -> {
            if (response instanceof GatewayServerResponse) {
                GatewayServerResponse res = (GatewayServerResponse)response;
                res.setStatusCode(statusCode.resolve());
            }
            return response;
        };
    }

    public static BiFunction<ServerRequest, ServerResponse, ServerResponse> removeJsonAttributesResponseBody(List<String> fieldList, boolean deleteRecursively) {
        List<String> immutableFieldList = List.copyOf(fieldList);
        return AfterFilterFunctions.modifyResponseBody(String.class, String.class, "application/json", (request, response, body) -> {
            String responseBody = body;
            if (MediaType.APPLICATION_JSON.isCompatibleWith(response.headers().getContentType())) {
                try {
                    JsonNode jsonBodyContent = (JsonNode)OBJECT_MAPPER.readValue(responseBody, JsonNode.class);
                    AfterFilterFunctions.removeJsonAttributes(jsonBodyContent, immutableFieldList, deleteRecursively);
                    responseBody = OBJECT_MAPPER.writeValueAsString((Object)jsonBodyContent);
                }
                catch (JsonProcessingException exception) {
                    throw new IllegalStateException("Failed to process JSON of response body.", exception);
                }
            }
            return responseBody;
        });
    }

    private static void removeJsonAttributes(JsonNode jsonNode, List<String> fieldNames, boolean deleteRecursively) {
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            objectNode.remove(fieldNames);
        }
        if (deleteRecursively) {
            jsonNode.forEach(childNode -> AfterFilterFunctions.removeJsonAttributes(childNode, fieldNames, true));
        }
    }

    public static enum DedupeStrategy {
        RETAIN_FIRST,
        RETAIN_LAST,
        RETAIN_UNIQUE;

    }
}

