/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.net.URI;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.filter.HttpHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.handler.ProxyExchange;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import org.springframework.web.util.UriComponentsBuilder;

public class ProxyExchangeHandlerFunction
implements HandlerFunction<ServerResponse>,
ApplicationListener<ContextRefreshedEvent> {
    private static final Log log = LogFactory.getLog(ProxyExchangeHandlerFunction.class);
    private final ProxyExchange proxyExchange;
    private final ObjectProvider<HttpHeadersFilter.RequestHttpHeadersFilter> requestHttpHeadersFiltersProvider;
    private final ObjectProvider<HttpHeadersFilter.ResponseHttpHeadersFilter> responseHttpHeadersFiltersProvider;
    private List<HttpHeadersFilter.RequestHttpHeadersFilter> requestHttpHeadersFilters;
    private List<HttpHeadersFilter.ResponseHttpHeadersFilter> responseHttpHeadersFilters;
    private final URIResolver uriResolver;

    public ProxyExchangeHandlerFunction(ProxyExchange proxyExchange, ObjectProvider<HttpHeadersFilter.RequestHttpHeadersFilter> requestHttpHeadersFilters, ObjectProvider<HttpHeadersFilter.ResponseHttpHeadersFilter> responseHttpHeadersFilters) {
        this(proxyExchange, requestHttpHeadersFilters, responseHttpHeadersFilters, request -> (URI)request.attribute(MvcUtils.GATEWAY_REQUEST_URL_ATTR).orElseThrow(() -> new IllegalStateException("No routeUri resolved")));
    }

    public ProxyExchangeHandlerFunction(ProxyExchange proxyExchange, ObjectProvider<HttpHeadersFilter.RequestHttpHeadersFilter> requestHttpHeadersFilters, ObjectProvider<HttpHeadersFilter.ResponseHttpHeadersFilter> responseHttpHeadersFilters, URIResolver uriResolver) {
        this.proxyExchange = proxyExchange;
        this.requestHttpHeadersFiltersProvider = requestHttpHeadersFilters;
        this.responseHttpHeadersFiltersProvider = responseHttpHeadersFilters;
        this.uriResolver = uriResolver;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.init();
    }

    private void init() {
        this.requestHttpHeadersFilters = this.requestHttpHeadersFiltersProvider.orderedStream().toList();
        this.responseHttpHeadersFilters = this.responseHttpHeadersFiltersProvider.orderedStream().toList();
    }

    public ServerResponse handle(ServerRequest serverRequest) {
        URI uri = (URI)this.uriResolver.apply(serverRequest);
        MultiValueMap<String, String> params = MvcUtils.encodeQueryParams((MultiValueMap<String, String>)serverRequest.params());
        URI url = UriComponentsBuilder.fromUri((URI)serverRequest.uri()).scheme(uri.getScheme()).host(uri.getHost()).port(uri.getPort()).replaceQueryParams(params).build(true).toUri();
        HttpHeaders filteredRequestHeaders = this.filterHeaders(this.requestHttpHeadersFilters, serverRequest.headers().asHttpHeaders(), serverRequest);
        boolean preserveHost = serverRequest.attributes().getOrDefault(MvcUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, false);
        if (preserveHost) {
            filteredRequestHeaders.set("Host", serverRequest.headers().firstHeader("Host"));
        } else {
            filteredRequestHeaders.remove("Host");
        }
        ProxyExchange.Request proxyRequest = this.proxyExchange.request(serverRequest).uri(url).headers(filteredRequestHeaders).responseConsumer((response, serverResponse) -> {
            HttpHeaders httpHeaders = this.filterHeaders(this.responseHttpHeadersFilters, response.getHeaders(), serverResponse);
            serverResponse.headers().putAll(httpHeaders);
        }).build();
        return this.proxyExchange.exchange(proxyRequest);
    }

    private <REQUEST_OR_RESPONSE> HttpHeaders filterHeaders(List<?> filters, HttpHeaders original, REQUEST_OR_RESPONSE requestOrResponse) {
        HttpHeaders filtered = original;
        for (Object filter : filters) {
            HttpHeadersFilter typed = (HttpHeadersFilter)filter;
            filtered = (HttpHeaders)typed.apply(filtered, requestOrResponse);
        }
        return filtered;
    }

    public static interface URIResolver
    extends Function<ServerRequest, URI> {
    }
}

