/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.servlet.autoconfigure.MultipartAutoConfiguration;
import org.springframework.boot.servlet.autoconfigure.MultipartProperties;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayMvcMultipartResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

@AutoConfiguration(before={MultipartAutoConfiguration.class})
@ConditionalOnClass(value={Servlet.class, StandardServletMultipartResolver.class, MultipartConfigElement.class})
@ConditionalOnProperty(prefix="spring.servlet.multipart", name={"enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={MultipartProperties.class})
public class GatewayMultipartAutoConfiguration {
    @Bean(name={"multipartResolver"})
    @ConditionalOnMissingBean(value={MultipartResolver.class})
    public GatewayMvcMultipartResolver gatewayMvcMultipartResolver(MultipartProperties properties) {
        GatewayMvcMultipartResolver multipartResolver = new GatewayMvcMultipartResolver();
        multipartResolver.setResolveLazily(properties.isResolveLazily());
        return multipartResolver;
    }
}

